/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection.c_cpp;

import com.teamscale.index.code_change.MethodMatchRegion;
import com.teamscale.index.code_change.refactoring_detection.CLikeMethodRefactoringDetectorStrategyBase;
import com.teamscale.index.code_change.refactoring_detection.RenameDetector;
import com.teamscale.index.code_change.refactoring_detection.c_cpp.CppThisKeywordInsertionDetector;
import com.teamscale.index.code_change.refactoring_detection.c_cpp.NamespaceChangeDetector;
import com.teamscale.index.code_change.refactoring_detection.c_cpp.TypeDeductionDetector;
import com.teamscale.index.code_change.refactoring_detection.c_cpp.UnifiedInitializationExchangeDetector;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CppAndCMethodRefactoringDetectorStrategy
extends CLikeMethodRefactoringDetectorStrategyBase {
    private final Map<String, Map<String, List<IToken>>> aliasLookupCacheOldEntities = new HashMap<String, Map<String, List<IToken>>>();
    private final Map<String, Map<String, List<IToken>>> aliasLookupCacheNewEntities = new HashMap<String, Map<String, List<IToken>>>();

    public CppAndCMethodRefactoringDetectorStrategy(ELanguage language, RenameDetector renameDetector) {
        super(language, renameDetector);
        this.detectors.add(new TypeDeductionDetector());
        this.detectors.add(new CppThisKeywordInsertionDetector());
        this.detectors.add(new NamespaceChangeDetector(this.methodCallPatternMapping));
        this.detectors.add(new UnifiedInitializationExchangeDetector());
    }

    @Override
    protected boolean areStatementsEqual(ShallowEntity oldEntity, List<IToken> oldTokens, ShallowEntity newEntity, List<IToken> newTokens) {
        List<IToken> resolvedOldtokens = CppAndCMethodRefactoringDetectorStrategy.getTypeAliasResolvedTokens(this.aliasLookupCacheOldEntities, oldEntity, oldTokens);
        List<IToken> resolvedNewtokens = CppAndCMethodRefactoringDetectorStrategy.getTypeAliasResolvedTokens(this.aliasLookupCacheNewEntities, newEntity, newTokens);
        return super.areStatementsEqual(oldEntity, resolvedOldtokens, newEntity, resolvedNewtokens);
    }

    private static List<IToken> getTypeAliasResolvedTokens(Map<String, Map<String, List<IToken>>> aliasLookupCache, ShallowEntity entity, List<IToken> tokensToResolve) {
        List allTokens = entity.getAllTokensOfFile();
        if (allTokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        Map entityAliasMapping = aliasLookupCache.computeIfAbsent(TokenStreamUtils.determineMostSpecificOrigin((Collection)allTokens), path -> LanguageFeatureParser.CPP.getAliasMapping(allTokens));
        return LanguageFeatureParser.CPP.resolveAliases(tokensToResolve, entityAliasMapping);
    }

    @Override
    public void addAllMatchedMethods(List<MethodMatchRegion> methodMatchRegions) {
        for (MethodMatchRegion newRegion : methodMatchRegions) {
            MethodMatchRegion match = (MethodMatchRegion)newRegion.getMatch();
            if (match == null) continue;
            this.methodCallPatternMapping.storeMapping(match, newRegion);
        }
    }
}

