/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection.c_cpp;

import com.teamscale.index.code_change.refactoring_detection.ELocalRefactoringDetectionResult;
import com.teamscale.index.code_change.refactoring_detection.ILocalRefactoringDetector;
import com.teamscale.index.code_change.refactoring_detection.MethodCallPatternMapping;
import com.teamscale.index.code_change.refactoring_detection.ParallelTokenListIterator;
import com.teamscale.index.code_change.refactoring_detection.TypeAwareTokenListIterator;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;

public class NamespaceChangeDetector
implements ILocalRefactoringDetector {
    private static final TokenTypePattern METHOD_CALL_PATTERN = new TokenTypePattern("(<IDENTIFIER>(<SCOPE><IDENTIFIER>)*)<LPAREN>");
    private MethodCallPatternMapping methodIdMappings;

    public NamespaceChangeDetector(MethodCallPatternMapping methodIdMapping) {
        this.methodIdMappings = methodIdMapping;
    }

    @Override
    public ELocalRefactoringDetectionResult process(ParallelTokenListIterator parallelTokenListIterator) {
        boolean matchesAtPreviousPosition;
        boolean bl = matchesAtPreviousPosition = parallelTokenListIterator.bothMatchTypeSequence(-1, ETokenType.IDENTIFIER) && parallelTokenListIterator.bothMatchTypePattern(-1, METHOD_CALL_PATTERN);
        if (parallelTokenListIterator.bothMatchTypeSequence(0, ETokenType.IDENTIFIER) && parallelTokenListIterator.bothMatchTypePattern(0, METHOD_CALL_PATTERN) || matchesAtPreviousPosition) {
            String oldMethodCall = NamespaceChangeDetector.getMethodCall(parallelTokenListIterator.getOldTokenListIterator(), matchesAtPreviousPosition);
            String newMethodCall = NamespaceChangeDetector.getMethodCall(parallelTokenListIterator.getNewTokenListIterator(), matchesAtPreviousPosition);
            if (oldMethodCall == null || newMethodCall == null) {
                return ELocalRefactoringDetectionResult.NO_DECISION;
            }
            if (!this.methodIdMappings.containsMethodCallMapping(oldMethodCall, newMethodCall)) {
                return ELocalRefactoringDetectionResult.REAL_CHANGE;
            }
            while (parallelTokenListIterator.hasMoreTokens() && parallelTokenListIterator.tokenNameAndTypesEqual()) {
                if (parallelTokenListIterator.bothMatchTypeSequence(0, ETokenType.LPAREN)) {
                    return ELocalRefactoringDetectionResult.REFACTORING;
                }
                parallelTokenListIterator.next();
            }
        }
        return ELocalRefactoringDetectionResult.NO_DECISION;
    }

    private static String getMethodCall(TypeAwareTokenListIterator tokenListIterator, boolean includePreviousToken) {
        StringBuilder builder = new StringBuilder();
        if (includePreviousToken) {
            builder.append(tokenListIterator.getToken(tokenListIterator.getTokenPos() - 1).getText());
        } else {
            builder.append(tokenListIterator.getCurrentToken().getText());
        }
        IToken token = tokenListIterator.getCurrentToken();
        while (token.getType() != ETokenType.LPAREN && tokenListIterator.hasCurrentToken()) {
            tokenListIterator.incTokenPos(1);
            token = tokenListIterator.getCurrentToken();
            if (token.getType() != ETokenType.IDENTIFIER) continue;
            builder.append('#');
            builder.append(token.getText());
        }
        builder.append('#');
        int parameterCount = NamespaceChangeDetector.getParameterCount(tokenListIterator);
        if (parameterCount == -1) {
            return null;
        }
        builder.append(parameterCount);
        return builder.toString();
    }

    private static int getParameterCount(TypeAwareTokenListIterator tokenListIterator) {
        if (tokenListIterator.getTokenPos() >= tokenListIterator.size() - 1) {
            return -1;
        }
        if (tokenListIterator.getToken(tokenListIterator.getTokenPos() + 1).getType() == ETokenType.RPAREN) {
            return 0;
        }
        int parameterStart = tokenListIterator.getTokenPos();
        int parameters = 1;
        int nestingCounter = 0;
        while (tokenListIterator.hasCurrentToken()) {
            IToken token = tokenListIterator.getCurrentToken();
            if (EnumSet.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK).contains(token.getType())) {
                ++nestingCounter;
            } else if (EnumSet.of(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK).contains(token.getType())) {
                --nestingCounter;
            }
            if (nestingCounter == 0 && token.getType() == ETokenType.RPAREN) break;
            if (nestingCounter == 1 && token.getType() == ETokenType.COMMA) {
                ++parameters;
            }
            tokenListIterator.incTokenPos(1);
        }
        tokenListIterator.setTokenPos(parameterStart);
        return parameters;
    }
}

