/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.classification.CodeCharacteristicsChecker;
import com.teamscale.index.comment_analysis.utils.CommentUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class CommentLineCodeChecker {
    private int tokenCount;
    private int operatorAndDelimiterCount;
    private final List<Integer> keywordIndices;
    private final List<IToken> tokens;
    private static final Set<ETokenType> LEFT_OPENINGS = CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.LPAREN, ETokenType.LBRACK});
    private static final Set<ETokenType> RIGHT_OPENINGS = CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.RPAREN, ETokenType.RBRACK});
    private static final Set<ETokenType.ETokenClass> DELIMITER_AND_OPERATORS = CollectionUtils.asHashSet((Object[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.DELIMITER, ETokenType.ETokenClass.OPERATOR});
    private static final EnumSet<ELanguage> CLIKE_LANGUAGES = EnumSet.of(ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP);
    private static final ITokenMatcher CLIKE_BLOCK_STATEMENT_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.WHILE, ETokenType.FOR});

    public CommentLineCodeChecker(List<IToken> tokens) {
        this.tokens = tokens;
        this.keywordIndices = new ArrayList<Integer>();
        this.tokenCount = 0;
        this.operatorAndDelimiterCount = 0;
    }

    public CodeCharacteristicsChecker.ECodeLineResult containsCodeCharacteristics() {
        if (this.tokens.size() < 2 || this.hasThreeConsecutiveIdentifiers() || this.statementStartsWithIdentifierAndKeywordFollows()) {
            return CodeCharacteristicsChecker.ECodeLineResult.NO_CODE;
        }
        if (CLIKE_LANGUAGES.contains(this.tokens.get(0).getLanguage()) && this.leftParenthesisFollowsBlockStatementStartToken()) {
            return CodeCharacteristicsChecker.ECodeLineResult.NO_CODE;
        }
        for (int index = 0; index < this.tokens.size(); ++index) {
            IToken token = this.tokens.get(index);
            ETokenType tokenType = token.getType();
            ETokenType.ETokenClass tokenClass = tokenType.getTokenClass();
            if (tokenClass == ETokenType.ETokenClass.ERROR) {
                return CodeCharacteristicsChecker.ECodeLineResult.NO_CODE;
            }
            if (CodeCharacteristicsChecker.IGNORED_TOKEN_CLASSES.contains(tokenClass) || CodeCharacteristicsChecker.COMMON_NL_TOKENS.contains(tokenType) || CommentLineCodeChecker.isTextualOperator(token) || this.isParamLikeCommentTag(tokenType, index)) continue;
            ++this.tokenCount;
            this.processToken(index, tokenType, tokenClass);
        }
        this.operatorAndDelimiterCount += CommentLineCodeChecker.countCodeKeywords(this.tokens, this.keywordIndices);
        if (this.operatorAndDelimiterCount >= 2 && (double)this.operatorAndDelimiterCount / (double)this.tokenCount > 0.43) {
            return CodeCharacteristicsChecker.ECodeLineResult.CODE;
        }
        return CodeCharacteristicsChecker.ECodeLineResult.DONT_KNOW;
    }

    private boolean isParamLikeCommentTag(ETokenType tokenType, int index) {
        return tokenType == ETokenType.AT_OPERATOR && index < this.tokens.size() - 1 && CommentUtils.JAVA_DOC_TAGS.contains("@" + this.tokens.get(index + 1).getText());
    }

    private boolean leftParenthesisFollowsBlockStatementStartToken() {
        List blockStatementStartTokenIndices = TokenStreamUtils.findAll(this.tokens, (ITokenMatcher)CLIKE_BLOCK_STATEMENT_START_TOKENS);
        return !blockStatementStartTokenIndices.isEmpty() && blockStatementStartTokenIndices.stream().noneMatch(tokenIndex -> tokenIndex < this.tokens.size() - 1 && this.tokens.get(tokenIndex + 1).getType() == ETokenType.LPAREN);
    }

    private static boolean isTextualOperator(IToken token) {
        return token.getType().getTokenClass() == ETokenType.ETokenClass.OPERATOR && Character.isAlphabetic(token.getText().charAt(0));
    }

    private void processToken(int index, ETokenType tokenType, ETokenType.ETokenClass tokenClass) {
        switch (tokenClass) {
            case IDENTIFIER: {
                this.processIdentifier(index);
                break;
            }
            case KEYWORD: {
                this.processKeywordForAnnotations(index, tokenType);
                break;
            }
            case DELIMITER: 
            case OPERATOR: {
                if (tokenType == ETokenType.MINUS) {
                    return;
                }
                ++this.operatorAndDelimiterCount;
                break;
            }
        }
    }

    private void processIdentifier(int index) {
        IToken secondNextToken;
        IToken nextToken;
        IToken previousToken;
        IToken secondPreviousToken = this.getPreviousToken(index - 1);
        if (CommentLineCodeChecker.isMethodCallOrArrayAccess(secondPreviousToken, previousToken = this.getPreviousToken(index), nextToken = this.getNextToken(index), secondNextToken = this.getNextToken(index + 1))) {
            return;
        }
        if (previousToken != null && LEFT_OPENINGS.contains(previousToken.getType())) {
            --this.operatorAndDelimiterCount;
        }
    }

    private static boolean isMethodCallOrArrayAccess(IToken secondPreviousToken, IToken previousToken, IToken nextToken, IToken secondNextToken) {
        if (secondPreviousToken == null || secondPreviousToken.getType() != ETokenType.IDENTIFIER && previousToken == null || !LEFT_OPENINGS.contains(previousToken.getType())) {
            return false;
        }
        if (nextToken == null || secondNextToken == null) {
            return false;
        }
        if (RIGHT_OPENINGS.contains(nextToken.getType()) && DELIMITER_AND_OPERATORS.contains(secondNextToken.getType().getTokenClass())) {
            return true;
        }
        return ETokenType.ETokenClass.DELIMITER == nextToken.getType().getTokenClass() && ETokenType.ETokenClass.IDENTIFIER == secondNextToken.getType().getTokenClass();
    }

    private void processKeywordForAnnotations(int index, ETokenType tokenType) {
        if (!CodeCharacteristicsChecker.IDENTIFER_TYPES.contains(tokenType)) {
            this.keywordIndices.add(index);
        }
    }

    private IToken getPreviousToken(int tokenIndex) {
        if (tokenIndex <= 0) {
            return null;
        }
        return this.tokens.get(tokenIndex - 1);
    }

    private IToken getNextToken(int tokenIndex) {
        int numTokens = this.tokens.size();
        if (tokenIndex + 1 > numTokens - 1) {
            return null;
        }
        return this.tokens.get(tokenIndex + 1);
    }

    private boolean hasThreeConsecutiveIdentifiers() {
        int consecutiveCount = 0;
        for (IToken token : this.tokens) {
            if (CodeCharacteristicsChecker.IDENTIFER_TYPES.contains(token.getType())) {
                if (++consecutiveCount < 3) continue;
                return true;
            }
            consecutiveCount = 0;
        }
        return false;
    }

    private boolean statementStartsWithIdentifierAndKeywordFollows() {
        return this.tokens.size() >= 2 && this.tokens.get(0).getType() == ETokenType.IDENTIFIER && ETokenType.KEYWORDS.contains((Object)this.tokens.get(1).getType());
    }

    private static int countCodeKeywords(List<IToken> tokens, List<Integer> keywordIndices) {
        return keywordIndices.size() - CommentLineCodeChecker.countNonCodeKeywords(tokens, keywordIndices);
    }

    private static int countNonCodeKeywords(List<IToken> tokens, List<Integer> keywordIndices) {
        int nonCodeKeywords = 0;
        for (int i = 0; i < keywordIndices.size(); ++i) {
            IToken currentToken = tokens.get(keywordIndices.get(i));
            List<IToken> succeedingNonKeywordTokens = null;
            if (CollectionUtils.isValidIndex((int)(i + 1), keywordIndices)) {
                succeedingNonKeywordTokens = tokens.subList(keywordIndices.get(i) + 1, keywordIndices.get(i + 1));
            }
            if (CommentLineCodeChecker.isKeywordUsedAsNaturalLanguage(currentToken, succeedingNonKeywordTokens)) {
                ++nonCodeKeywords;
                continue;
            }
            if (!CommentLineCodeChecker.isValidIdentifier(currentToken)) continue;
            ++nonCodeKeywords;
        }
        return nonCodeKeywords;
    }

    private static boolean isValidIdentifier(IToken candidateKeywordToken) {
        ELanguage language = candidateKeywordToken.getLanguage();
        if (language == ELanguage.C || language == ELanguage.OBJECTIVE_C) {
            return LanguageFeatureParser.C.isValidIdentifier(candidateKeywordToken);
        }
        if (language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI || language == ELanguage.OBJECTIVE_CPP) {
            return LanguageFeatureParser.CPP.isValidIdentifier(candidateKeywordToken);
        }
        return false;
    }

    private static boolean isKeywordUsedAsNaturalLanguage(IToken candidateKeywordToken, @Nullable List<IToken> succeedingNonKeywordToken) {
        if (succeedingNonKeywordToken == null || !CodeCharacteristicsChecker.KEYWORDS_NEEDING_SYNTAX_CHECK.contains(candidateKeywordToken.getText())) {
            return false;
        }
        return succeedingNonKeywordToken.size() < 4 || TokenStreamUtils.containsAll(succeedingNonKeywordToken, (ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.RPAREN}) || TokenStreamUtils.containsAll(succeedingNonKeywordToken, (ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.RBRACE});
    }
}

