/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools.message;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.SonarLintCsConfiguration;
import com.teamscale.index.configuration.tools.message.TsvMessageManagerBase;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.resources.Resource;

public class SonarLintMessageManager
extends TsvMessageManagerBase {
    private static SonarLintMessageManager instance;
    private final Map<String, CheckMapping> checkMappingsBySonarRuleKey = new HashMap<String, CheckMapping>();
    private final Map<String, String> groupToQualityIndicatorMapping = new HashMap<String, String>();

    private SonarLintMessageManager() {
        super(Resource.of(SonarLintCsConfiguration.class, (String)"message/sonarlint/check-mappings.tsv"));
        this.readMappingsAndDescriptions();
    }

    public static synchronized SonarLintMessageManager getInstance() {
        if (instance == null) {
            instance = new SonarLintMessageManager();
        }
        return instance;
    }

    private void readMappingsAndDescriptions() {
        for (Map.Entry entry : this.checkMappings.entrySet()) {
            String ruleId = (String)entry.getKey();
            CheckMapping mapping = (CheckMapping)entry.getValue();
            this.groupToQualityIndicatorMapping.put(mapping.group, mapping.category);
            this.checkMappingsBySonarRuleKey.put(ruleId, mapping);
        }
    }

    @Override
    public String getFindingCategoryName() {
        return null;
    }

    public Map<String, String> getGroupToQualityIndicatorMapping() {
        return this.groupToQualityIndicatorMapping;
    }

    public static ELanguage getRuleLanguage(String ruleId) throws ProjectConfigurationException {
        String language;
        String[] languageSplit = ruleId.split(":");
        if (languageSplit.length < 2) {
            throw new ProjectConfigurationException("Invalid rule ID provided: " + ruleId);
        }
        return switch (language = languageSplit[0]) {
            case "java" -> ELanguage.JAVA;
            case "kotlin" -> ELanguage.KOTLIN;
            case "php" -> ELanguage.PHP;
            case "javascript", "typescript", "js", "ts" -> ELanguage.JAVASCRIPT;
            default -> throw new AssertionError((Object)("Unsupported language " + language + "! Please define the mapping above."));
        };
    }

    public CheckMapping getCheckMappingBySonarRuleKey(String sonarRuleKey) {
        return this.checkMappingsBySonarRuleKey.get(sonarRuleKey);
    }
}

