/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReturnValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphParameter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MethodTaintGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> influenceGraph;
    private final Set<String> influencingMethodIdentifiers = new HashSet<String>();
    private long timestamp;
    private String methodIdentifier;

    public Set<String> getInfluencingMethodIdentifiers() {
        return this.influencingMethodIdentifiers;
    }

    public Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> getInfluenceGraph() {
        return this.influenceGraph;
    }

    public void addInfluencingMethodIdentifiers(Collection<String> influencingMethodIdentifier) {
        this.influencingMethodIdentifiers.addAll(influencingMethodIdentifier);
    }

    public String getMethodIdentifier() {
        return this.methodIdentifier;
    }

    public MethodTaintGraph(String methodIdentifier, Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> influenceGraph, long commitTimestamp) {
        CCSMAssert.isNotNull(influenceGraph);
        this.timestamp = commitTimestamp;
        if (influenceGraph.containsValue(null)) {
            Map.Entry faultyEntry = influenceGraph.entrySet().stream().filter(entry -> entry.getValue() == null).findAny().get();
            CCSMAssert.fail((String)("TaintGraph initialized with " + String.valueOf(faultyEntry.getKey()) + " mapped to null."));
        }
        this.methodIdentifier = methodIdentifier;
        this.influenceGraph = new HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>(influenceGraph);
    }

    public static Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> clearLocalReferences(Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> originalTable, Map<String, TaintGraphReferenceBase> finalReferenceMap, Set<MethodCallReference> callsInMethod) {
        Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> closuresMap = MethodTaintGraph.buildClosuresMap(originalTable, finalReferenceMap, callsInMethod);
        HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> newTable = new HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>();
        block4: for (Map.Entry<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> entry : closuresMap.entrySet()) {
            TaintGraphReferenceBase key = entry.getKey();
            switch (key.getType()) {
                case LOCAL: 
                case METHOD_CALL_RETURN: {
                    continue block4;
                }
                case FIELD: 
                case RETURN_VALUE: 
                case PARAMETER: {
                    if (finalReferenceMap.containsValue(key)) break;
                    continue block4;
                }
            }
            newTable.put(entry.getKey(), MethodTaintGraph.filterInfluences(finalReferenceMap, entry.getValue()));
        }
        return newTable;
    }

    private static Set<TaintGraphReferenceBase> filterInfluences(Map<String, TaintGraphReferenceBase> finalReferenceMap, Set<TaintGraphReferenceBase> unfilteredInfluences) {
        return CollectionUtils.filterToSet(unfilteredInfluences, ref -> {
            switch (ref.getType()) {
                case LOCAL: 
                case RETURN_VALUE: 
                case SINK: {
                    return false;
                }
                case PARAMETER: {
                    return !((TaintGraphParameter)ref).hasAnyModifierOf(TaintGraphParameter.EParameterModifier.EXPORTING);
                }
                case FIELD: {
                    return finalReferenceMap.containsValue(ref) || ref.getSsaIndex().equals("init");
                }
            }
            return true;
        });
    }

    private static Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> buildClosuresMap(Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> originalTable, Map<String, TaintGraphReferenceBase> finalReferenceMap, Set<MethodCallReference> callsInMethod) {
        HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> closuresMap = HashMap.newHashMap(originalTable.size());
        for (TaintGraphReferenceBase finalReference : finalReferenceMap.values()) {
            MethodTaintGraph.getInfluenceClosure(finalReference, originalTable, closuresMap, new HashSet<TaintGraphReferenceBase>());
        }
        for (TaintGraphReferenceBase finalReference : originalTable.keySet()) {
            MethodTaintGraph.getInfluenceClosure(finalReference, originalTable, closuresMap, new HashSet<TaintGraphReferenceBase>());
        }
        for (MethodCallReference call : callsInMethod) {
            for (TaintGraphReferenceBase methodCallInfluence : call.getAllInfluencingParameters()) {
                MethodTaintGraph.getInfluenceClosure(methodCallInfluence, originalTable, closuresMap, new HashSet<TaintGraphReferenceBase>());
            }
            Set inputFields = call.getFieldReferences().values().stream().map(ImmutablePair::getFirst).collect(Collectors.toSet());
            for (TaintGraphReferenceBase methodCallInfluence : inputFields) {
                MethodTaintGraph.getInfluenceClosure(methodCallInfluence, originalTable, closuresMap, new HashSet<TaintGraphReferenceBase>());
            }
        }
        return closuresMap;
    }

    private static Set<TaintGraphReferenceBase> getInfluenceClosure(TaintGraphReferenceBase reference, Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> influenceMap, Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> closuresMap, Set<TaintGraphReferenceBase> cycleBlocker) {
        if (cycleBlocker.contains(reference)) {
            return Collections.emptySet();
        }
        if (closuresMap.containsKey(reference)) {
            return closuresMap.get(reference);
        }
        HashSet<TaintGraphReferenceBase> closure = new HashSet<TaintGraphReferenceBase>();
        Set<TaintGraphReferenceBase> directInfluences = influenceMap.get(reference);
        if (directInfluences == null) {
            return Collections.emptySet();
        }
        for (TaintGraphReferenceBase influence : directInfluences) {
            closure.add(influence);
            cycleBlocker.add(influence);
            closure.addAll(MethodTaintGraph.getInfluenceClosure(influence, influenceMap, closuresMap, cycleBlocker));
            cycleBlocker.remove(influence);
        }
        closuresMap.put(reference, closure);
        return closure;
    }

    public Optional<Set<TaintGraphReferenceBase>> getDirectReturnValueInfluences(MethodCallReturnValueReference returnValueReference) {
        Optional<TaintGraphReferenceBase> localReference = this.getLocalReferenceToCallReturnValue(returnValueReference);
        if (returnValueReference.getReturnValueType() == MethodCallReturnValueReference.EReturnParameterType.ASSIGNEE && !localReference.isPresent()) {
            return Optional.of(Collections.emptySet());
        }
        if (!localReference.isPresent()) {
            return Optional.empty();
        }
        Set<TaintGraphReferenceBase> influences = this.influenceGraph.get(localReference.get());
        if (influences == null) {
            return Optional.empty();
        }
        return Optional.of(CollectionUtils.filterToSet(influences, influence -> EnumSet.of(TaintGraphReferenceBase.EReferenceType.PARAMETER, TaintGraphReferenceBase.EReferenceType.FIELD, TaintGraphReferenceBase.EReferenceType.SOURCE, TaintGraphReferenceBase.EReferenceType.RFC_SOURCE).contains((Object)influence.getType())));
    }

    public Optional<TaintGraphReferenceBase> getLocalReferenceToCallReturnValue(MethodCallReturnValueReference returnValueReference) {
        TaintGraphReferenceBase localReference = null;
        switch (returnValueReference.getReturnValueType()) {
            case ASSIGNEE: {
                localReference = this.getLocalReferenceToAssigneeReturnValue();
                break;
            }
            case FIELD: {
                localReference = this.getLocalReferenceToFieldReturnValue(returnValueReference);
                break;
            }
            case RECEIVING: 
            case NAMED: 
            case CHANGING: 
            case IMPORTING: {
                localReference = this.getLocalReferenceToParameterReturnValue(returnValueReference);
                break;
            }
            case UNNAMED: {
                if (!StringUtils.isInteger((String)returnValueReference.getParameterId())) break;
                int parameterIndex = Integer.parseInt(returnValueReference.getParameterId());
                localReference = this.getLocalReferenceToUnnamedParameter(localReference, parameterIndex);
                break;
            }
            default: {
                CCSMAssert.fail((String)"unexpected callee return value reference type");
            }
        }
        return Optional.ofNullable(localReference);
    }

    private TaintGraphReferenceBase getLocalReferenceToUnnamedParameter(TaintGraphReferenceBase localReference, int parameterIndex) {
        Optional<TaintGraphParameter> parameterAtIndex = this.influenceGraph.keySet().stream().filter(entry -> entry.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER).map(entry -> (TaintGraphParameter)entry).filter(entry -> entry.getParameterIndex() == parameterIndex).findAny();
        if (parameterAtIndex.isPresent()) {
            localReference = parameterAtIndex.get();
        }
        return localReference;
    }

    private TaintGraphReferenceBase getLocalReferenceToParameterReturnValue(MethodCallReturnValueReference returnValueReference) {
        Optional<TaintGraphReferenceBase> optionalLocalReturnValue = this.influenceGraph.keySet().stream().filter(entry -> entry.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER && entry.getReferenceName().equals(returnValueReference.getParameterId())).findAny();
        if (optionalLocalReturnValue.isPresent()) {
            return optionalLocalReturnValue.get();
        }
        return null;
    }

    private TaintGraphReferenceBase getLocalReferenceToFieldReturnValue(MethodCallReturnValueReference returnValueReference) throws AssertionError {
        List localReferences = this.influenceGraph.keySet().stream().filter(entry -> entry.getType() == TaintGraphReferenceBase.EReferenceType.FIELD && entry.getReferenceName().equals(returnValueReference.getParameterId())).collect(Collectors.toList());
        if (localReferences.isEmpty()) {
            return null;
        }
        if (localReferences.size() == 1) {
            return (TaintGraphReferenceBase)localReferences.get(0);
        }
        CCSMAssert.fail((String)"found more than one reference to a field in a MethodTaintGraph");
        return null;
    }

    private TaintGraphReferenceBase getLocalReferenceToAssigneeReturnValue() {
        Optional<TaintGraphReferenceBase> optionalLocalReturnValue = this.influenceGraph.keySet().stream().filter(entry -> entry.getType() == TaintGraphReferenceBase.EReferenceType.RETURN_VALUE).findAny();
        TaintGraphReferenceBase localReference = optionalLocalReturnValue.isPresent() ? optionalLocalReturnValue.get() : null;
        return localReference;
    }

    public String toString() {
        String taintGraphEntries = StringUtils.concat((Iterable)this.influenceGraph.entrySet().stream().map(entry -> entry.toString()).collect(Collectors.toList()), (String)"\n");
        return "\nTaintGraph for " + this.methodIdentifier + "\n" + taintGraphEntries + "\nInf: " + String.valueOf(this.influencingMethodIdentifiers);
    }

    public Set<TaintGraphSink> getSinksDirectlyInfluencedBy(MethodCallInputValueReference callInputReference) {
        Set allSinks = this.influenceGraph.keySet().stream().filter(key -> key.getType() == TaintGraphReferenceBase.EReferenceType.SINK).map(key -> (TaintGraphSink)key).collect(Collectors.toSet());
        HashSet<TaintGraphSink> influencedSinks = new HashSet<TaintGraphSink>();
        for (TaintGraphSink sink : allSinks) {
            for (TaintGraphReferenceBase influence : this.influenceGraph.get(sink)) {
                if (!MethodTaintGraph.callInputMatchesLocalReference(callInputReference, influence)) continue;
                influencedSinks.add(sink);
            }
        }
        return influencedSinks;
    }

    protected static boolean callInputMatchesLocalReference(MethodCallInputValueReference callInputReference, TaintGraphReferenceBase localReference) throws AssertionError {
        switch (callInputReference.getInputValueType()) {
            case UNNAMED: {
                int parameterIndex = Integer.parseInt(callInputReference.getParameterId());
                if (localReference.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER) {
                    TaintGraphParameter influenceParameter = (TaintGraphParameter)localReference;
                    return influenceParameter.hasAnyModifierOf(TaintGraphParameter.EParameterModifier.IMPORTING, TaintGraphParameter.EParameterModifier.USING) && influenceParameter.getParameterIndex() == parameterIndex;
                }
                return false;
            }
            case NAMED: {
                String parameterName = callInputReference.getParameterId();
                return localReference.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER && localReference.getReferenceName().equals(parameterName);
            }
            case FIELD: {
                String fieldName = callInputReference.getParameterId();
                return localReference.getType() == TaintGraphReferenceBase.EReferenceType.FIELD && localReference.getReferenceName().equals(fieldName);
            }
        }
        CCSMAssert.fail((String)"unexpected callee return value reference type");
        return false;
    }

    public TaintGraphReferenceBase getNewestOutputRefSSAof(String referenceName) {
        CCSMAssert.isTrue((this.influenceGraph.keySet().stream().filter(key -> key.getReferenceName().equals(referenceName)).count() <= 1L ? 1 : 0) != 0, (String)"found more than one SSA for a given reference name in a MethodTaintGraph!");
        for (TaintGraphReferenceBase outputRef : this.influenceGraph.keySet()) {
            if (!outputRef.getReferenceName().equals(referenceName)) continue;
            return outputRef;
        }
        return null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean containsSameDataflowAs(MethodTaintGraph other) {
        if (other == null) {
            return false;
        }
        return this.methodIdentifier.equals(other.methodIdentifier) && this.influenceGraph.equals(other.influenceGraph) && this.influencingMethodIdentifiers.equals(other.influencingMethodIdentifiers);
    }

    public static MethodTaintGraph fromMap(String methodIdentifier, Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> referenceMap, long commitTimestamp) {
        CCSMAssert.isNotNull(referenceMap);
        return new MethodTaintGraph(methodIdentifier, referenceMap, commitTimestamp);
    }
}

