/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.hana_view;

import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class HanaDependencyExtractionHandler
extends DefaultHandler {
    private static final String XML_ATTRIBUTE_COLUMN_OBJECT_NAME = "columnObjectName";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_RESOURCE_URI = "resourceUri";
    private static final String XML_ATTRIBUTE_SCHEMA_NAME = "schemaName";
    private static final String XML_ATTRIBUTE_TYPE = "type";
    private static final String SOURCE_OBJECT_TYPE_DATA_BASE_TABLE = "DATA_BASE_TABLE";
    private static final String XML_ELEMENT_COLUMN_OBJECT = "columnObject";
    private static final String XML_ELEMENT_DATA_SOURCE = "DataSource";
    private static final String XML_ELEMENT_RESOURCE_URI = "resourceUri";
    private static final String XML_ELEMENT_TARGET_VARIABLE = "targetVariable";
    private boolean isInDataSourceElement = false;
    private final Set<String> referencedResourceUris = new HashSet<String>();
    private final Set<String> referencedTableIds = new HashSet<String>();
    private StringBuilder resourceUriText = null;
    private String tableName = null;

    HanaDependencyExtractionHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String resourceUri;
        if (XML_ELEMENT_DATA_SOURCE.equals(qName)) {
            String type = attributes.getValue(XML_ATTRIBUTE_TYPE);
            if (SOURCE_OBJECT_TYPE_DATA_BASE_TABLE.equals(type)) {
                this.tableName = attributes.getValue(XML_ATTRIBUTE_ID);
            }
            this.isInDataSourceElement = true;
        } else if ("resourceUri".equals(qName) && this.isInDataSourceElement) {
            this.resourceUriText = new StringBuilder();
        } else if (XML_ELEMENT_COLUMN_OBJECT.equals(qName) && this.isInDataSourceTypeDataBaseTable()) {
            this.updateTableName(attributes.getValue(XML_ATTRIBUTE_SCHEMA_NAME), attributes.getValue(XML_ATTRIBUTE_COLUMN_OBJECT_NAME));
        } else if (XML_ELEMENT_TARGET_VARIABLE.equals(qName) && (resourceUri = attributes.getValue("resourceUri")) != null) {
            this.referencedResourceUris.add(resourceUri);
        }
    }

    private boolean isInDataSourceTypeDataBaseTable() {
        return this.tableName != null;
    }

    private void updateTableName(String schemaName, String columnObjectName) {
        if (StringUtils.isEmpty((String)columnObjectName)) {
            columnObjectName = this.tableName;
        }
        this.tableName = columnObjectName.replaceFirst("^/(\\w+)/", "!$1!");
        if (this.tableName.contains("::") || StringUtils.isEmpty((String)schemaName)) {
            return;
        }
        this.tableName = schemaName + "/" + this.tableName;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.resourceUriText != null) {
            this.resourceUriText.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("resourceUri".contentEquals(qName)) {
            this.referencedResourceUris.add(this.resourceUriText.toString());
            this.resourceUriText = null;
        } else if (XML_ELEMENT_DATA_SOURCE.equals(qName)) {
            this.isInDataSourceElement = false;
            if (this.tableName != null) {
                this.referencedTableIds.add(this.tableName);
                this.tableName = null;
            }
        }
    }

    public Set<String> getReferencedTableIds() {
        return this.referencedTableIds;
    }

    public Set<String> getReferencedResourceUris() {
        return this.referencedResourceUris;
    }
}

