/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.teamscale.index.external.CommitAssociatedExternalUploadIndexBase;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="external-analysis-results", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.NO_ROLLBACK, EStorageOption.BACKUP}, valueClasses={ExternalAnalysisCommitInfo.class, ExternalAnalysisResults.class})
public class ExternalAnalysisResultIndex
extends CommitAssociatedExternalUploadIndexBase<ExternalAnalysisCommitInfo> {
    public static final String INDEX_NAME = "external-analysis-results";
    private static final String PARTITION_SEPARATOR = "##";

    public ExternalAnalysisResultIndex(IStore store) {
        super(store);
    }

    public List<ExternalAnalysisResults> getAnalysisResults(String partition, List<String> paths) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String path : paths) {
            keys.add(ExternalAnalysisResultIndex.makePathKey(partition, path));
        }
        return CollectionUtils.mapWithException((Collection)this.store.getWithStrings(keys), StorageUtils::deserialize);
    }

    public void setAnalysisResults(String partition, PairList<String, ExternalAnalysisResults> pathToResultValues) throws StorageException {
        PairList keysValues = new PairList();
        for (int i = 0; i < pathToResultValues.size(); ++i) {
            keysValues.add((Object)ExternalAnalysisResultIndex.makePathKey(partition, (String)pathToResultValues.getFirst(i)), (Object)StorageUtils.serialize((Serializable)((Serializable)pathToResultValues.getSecond(i))));
        }
        this.store.putWithStrings(keysValues);
    }

    public List<String> getAllElementPaths(String partition) throws StorageException {
        ArrayList<String> paths = new ArrayList<String>();
        String prefix = ExternalAnalysisResultIndex.makePathKey(partition, "");
        this.store.scanKeys(StringUtils.stringToBytes((String)prefix), (key, value) -> {
            List list = paths;
            synchronized (list) {
                paths.add(StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)prefix));
            }
        });
        return paths;
    }

    public void removeElementResults(String partition, List<String> pathsToDelete) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String path : pathsToDelete) {
            keys.add(ExternalAnalysisResultIndex.makePathKey(partition, path));
        }
        this.store.removeWithStrings(keys);
    }

    public void removePartition(String partition) throws StorageException {
        this.store.removeByPrefix(ExternalAnalysisResultIndex.makePathKey(partition, ""));
    }

    public static String makePathKey(String partition, String path) {
        return partition + PARTITION_SEPARATOR + path;
    }

    public static List<ExternalAnalysisCommitInfo> loadCommitInfos(IBranchingLayer branchingLayer) throws StorageException {
        PairList allBranchNamesAndTimestamps = branchingLayer.getAllBranchNamesAndTimestamps();
        List values = branchingLayer.getValues(allBranchNamesAndTimestamps, StringUtils.stringToBytes((String)"#-#commit#-#"));
        return CollectionUtils.mapWithException((Collection)values, StorageUtils::deserialize).stream().filter(Objects::nonNull).map(value -> (ExternalAnalysisCommitInfo)((Object)((Object)value))).collect(Collectors.toList());
    }

    public static void validatePartitionName(@Nullable String name) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Partition name may not be empty.");
        }
        if (name.contains(PARTITION_SEPARATOR)) {
            throw new IllegalArgumentException("Partition name may not contain '##'.");
        }
    }
}

