/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.external.ExternalUploadIndexUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.rollback.StoreRollbackUtils;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.transaction.TransactionalStorageSystem;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jspecify.annotations.NonNull;

public class ExternalUploadIndexModifier<COMMIT extends Serializable> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProjectStorageSystem projectStorageSystem;
    private final TransactionalStorageSystem transactionalStorageSystem;
    private final SchemaAwareStorageSystem modificationStorageSystem;
    private final IStore inputResultStore;
    private final CommitLayeringBranchingLayer inputBranchingLayer;
    private final IStore outputResultStore;
    private final CommitLayeringBranchingLayer outputBranchingLayer;
    private final List<CommitDescriptor> rollbackCommits = new ArrayList<CommitDescriptor>();
    private final String indexName;
    private final Class<? extends ExternalUploadIndexBase<COMMIT>> indexClass;

    public ExternalUploadIndexModifier(IStorageSystem rawProjectStorageSystem, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider, IFactory<IStore, StorageException> tempStoreCreator, String indexName, Class<? extends ExternalUploadIndexBase<COMMIT>> indexClass) throws StorageException {
        this.projectStorageSystem = new ProjectStorageSystem(rawProjectStorageSystem, storageSystemCacheProvider);
        this.transactionalStorageSystem = new TransactionalStorageSystem(rawProjectStorageSystem, storageSystemCacheProvider, tempStoreCreator);
        this.modificationStorageSystem = new SchemaAwareStorageSystem((IStorageSystem)this.transactionalStorageSystem, StorageCacheRegistry.createStandaloneCacheProvider());
        this.indexName = indexName;
        this.indexClass = indexClass;
        this.inputResultStore = this.openRawExternalUploadIndex((SchemaAwareStorageSystem)this.projectStorageSystem);
        this.inputBranchingLayer = new CommitLayeringBranchingLayer(this.inputResultStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        this.outputResultStore = this.openRawExternalUploadIndex(this.modificationStorageSystem);
        this.outputBranchingLayer = new CommitLayeringBranchingLayer(this.outputResultStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
    }

    private void commitChanges() throws StorageException {
        this.transactionalStorageSystem.commit();
    }

    public void deleteCommits(Set<CommitDescriptor> commitsToDelete) throws StorageException {
        final Set<CommitDescriptor> existingCommitsToDelete = this.filterNonExistentCommits(commitsToDelete);
        Map<String, List<CommitDescriptor>> earliestTimestampByBranch = existingCommitsToDelete.stream().collect(Collectors.groupingBy(CommitDescriptor::getBranchName));
        List firstDeletedCommits = CollectionUtils.map(earliestTimestampByBranch.values(), commits -> ((CommitDescriptor)Collections.min(commits)).cloneWithDecrementedTimestamp());
        Map<String, Long> timestampByBranch = this.rollbackTo((CommitDescriptor)new RollbackRequestedCommitDescriptor(firstDeletedCommits, "Internal in " + String.valueOf(ExternalUploadIndexModifier.class)));
        this.replayCommits(timestampByBranch, new IReplayFilter(){

            @Override
            public boolean mayBeReplayed(ParentedCommitDescriptor commit) {
                return !existingCommitsToDelete.contains(commit);
            }

            @Override
            public ParentedCommitDescriptor adjustParent(ParentedCommitDescriptor commit) throws StorageException {
                CommitDescriptor parent = commit.getFirstParentCommit();
                while (parent != null && existingCommitsToDelete.contains(parent)) {
                    parent = HistoryUtils.resolveParentedCommit((IBranchingLayer)ExternalUploadIndexModifier.this.inputBranchingLayer, (CommitDescriptor)parent).getFirstParentCommit();
                }
                if (parent == null) {
                    return new ParentedCommitDescriptor((CommitDescriptor)commit, Collections.emptyList());
                }
                return new ParentedCommitDescriptor((CommitDescriptor)commit, new CommitDescriptor[]{parent});
            }
        });
        this.commitChanges();
    }

    private @NonNull Set<CommitDescriptor> filterNonExistentCommits(Set<CommitDescriptor> commits) throws StorageException {
        HashSet<CommitDescriptor> existingCommits = new HashSet<CommitDescriptor>();
        for (CommitDescriptor commit : commits) {
            if (HistoryUtils.resolveParentedCommit((IBranchingLayer)this.inputBranchingLayer, (CommitDescriptor)commit) == null) continue;
            existingCommits.add(commit);
        }
        return existingCommits;
    }

    private void replayCommits(Map<String, Long> timestampByBranch, IReplayFilter replayFilter) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        List allArtificialCommits = HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)this.inputBranchingLayer);
        for (ParentedCommitDescriptor artificialCommit : CollectionUtils.sort((Collection)allArtificialCommits)) {
            boolean needsReplay = RollbackTrigger.shouldBeDeleted((CommitDescriptor)artificialCommit, timestampByBranch) && replayFilter.mayBeReplayed(artificialCommit);
            if (!needsReplay) continue;
            this.replaySingleCommitWithRetry(replayFilter.adjustParent(artificialCommit));
        }
    }

    private void replaySingleCommitWithRetry(ParentedCommitDescriptor commitToCopy) throws StorageException {
        ExternalUploadIndexUtils.copyCommitWithRetry((CommitDescriptor)commitToCopy, () -> ExternalUploadIndexUtils.copyCommit(this.indexName, this.indexClass, commitToCopy, this.inputResultStore, this.outputResultStore), (RunnableWithException<StorageException>)((RunnableWithException)() -> this.recalculateInputHeadCommitsForBranches(Set.of(commitToCopy.getBranchName()))));
    }

    public void recalculateHeadCommitsForBranches(Set<String> branchNames) throws StorageException {
        for (String branchName : branchNames) {
            this.outputBranchingLayer.recalculateHeadCommitPointer(branchName);
        }
        this.commitChanges();
    }

    public void recalculateInputHeadCommitsForBranches(Set<String> branchNames) throws StorageException {
        for (String branchName : branchNames) {
            this.inputBranchingLayer.recalculateHeadCommitPointer(branchName);
        }
    }

    private Map<String, Long> rollbackTo(CommitDescriptor rollbackCommit) throws StorageException {
        Map timestampByBranch = RollbackTrigger.buildRollbackTimestampForBranchMap((CommitDescriptor)rollbackCommit, (ProjectStorageSystem)this.projectStorageSystem);
        StoreRollbackUtils.performRollback((SchemaAwareStorageSystem)this.modificationStorageSystem, (String)this.indexName, (IndexSchema)this.projectStorageSystem.getSchema(), (Map)timestampByBranch, (UUID)RollbackRequestedCommitDescriptor.getRollbackId((CommitDescriptor)rollbackCommit).orElseGet(UUID::randomUUID));
        if (rollbackCommit instanceof RichCommitDescriptor) {
            this.rollbackCommits.addAll((Collection<CommitDescriptor>)((RichCommitDescriptor)rollbackCommit).getSchedulingHints());
        } else {
            this.rollbackCommits.add(rollbackCommit);
        }
        return timestampByBranch;
    }

    private IStore openRawExternalUploadIndex(SchemaAwareStorageSystem projectStorageSystem) throws StorageException {
        return projectStorageSystem.openStoreChecked(this.indexName, this.indexClass, (IStorageSystem)projectStorageSystem, true, null);
    }

    public boolean scheduleRollbackIfNeeded(InternalProjectId internalProjectId, IndexLayer indexLayer) throws StorageException {
        if (this.rollbackCommits.isEmpty()) {
            return false;
        }
        Object rollbackCommit = this.rollbackCommits.size() == 1 ? this.rollbackCommits.get(0) : new RollbackRequestedCommitDescriptor(this.rollbackCommits, "Internal in " + String.valueOf(ExternalUploadIndexModifier.class));
        JobDescriptor rollbackJob = new JobDescriptor(internalProjectId, ForceRollbackTrigger.class, rollbackCommit, "Scheduled due to external analysis data modification.", RollbackRequestedCommitDescriptor.getRollbackId((CommitDescriptor)rollbackCommit).orElseGet(UUID::randomUUID));
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, rollbackJob);
        return true;
    }

    public AdditionInfo prepareForAddition(CommitDescriptor uploadCommit) throws StorageException {
        CommitDescriptor lastCommit = ExternalUploadIndexModifier.getLastCommitOnBranch((IBranchingLayer)this.inputBranchingLayer, uploadCommit.getBranchName());
        LOGGER.trace("prepareForAddition: start - uploadCommit={}, lastCommit={}", (Object)uploadCommit, (Object)lastCommit);
        Map<String, Long> timestampByBranch = Collections.emptyMap();
        ArrayList<CommitDescriptor> parentCommits = new ArrayList<CommitDescriptor>();
        if (lastCommit == null) {
            Optional<CommitDescriptor> bestParentCommit = this.findBestParentCommit(uploadCommit);
            bestParentCommit.ifPresent(parentCommits::add);
            if (bestParentCommit.isPresent()) {
                LOGGER.trace("prepareForAddition: last commit was null, found: bestParentCommit={}", (Object)bestParentCommit.get());
            } else {
                LOGGER.debug("prepareForAddition: last commit was null and no bestParentCommit found");
            }
        } else if (lastCommit.getTimestamp() < uploadCommit.getTimestamp()) {
            parentCommits.add(lastCommit);
            LOGGER.trace("prepareForAddition: last commit was not null, using: lastCommit={}", (Object)lastCommit);
        } else {
            LOGGER.trace("prepareForAddition: rollback required");
            timestampByBranch = this.rollbackTo(uploadCommit.cloneWithDecrementedTimestamp());
            lastCommit = ExternalUploadIndexModifier.getLastCommitOnBranch((IBranchingLayer)this.outputBranchingLayer, uploadCommit.getBranchName());
            if (lastCommit == null) {
                this.findBestParentCommit(uploadCommit).ifPresent(parentCommits::add);
            } else {
                parentCommits.add(lastCommit);
            }
            Map<String, Long> timestampByBranchForTrace = timestampByBranch;
            LOGGER.trace("prepareForAddition: rolled back - timestampByBranch=[{}], parentCommits=[{}]", new Supplier[]{() -> timestampByBranchForTrace.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "@" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")), () -> parentCommits.stream().sorted(Comparator.comparing(CommitDescriptor::getBranchName)).map(CommitDescriptor::toString).collect(Collectors.joining(", "))});
        }
        LOGGER.trace("prepareForAddition: finished - uploadCommit={}", (Object)uploadCommit);
        return new AdditionInfo(timestampByBranch, new ParentedCommitDescriptor(uploadCommit, parentCommits));
    }

    public static CommitDescriptor getLastCommitOnBranch(IBranchingLayer branchingLayer, String branchName) throws StorageException {
        IBranchCommitInfo headCommit = branchingLayer.readHeadCommit(branchName);
        if (headCommit == null) {
            return null;
        }
        return headCommit.toCommitDescriptor();
    }

    private Optional<CommitDescriptor> findBestParentCommit(CommitDescriptor writeCommit) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)this.projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        Optional existingCommit = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(writeCommit.cloneWithDecrementedTimestamp(), 0L);
        if (existingCommit.isPresent()) {
            List storedHistory = commitDescriptorIndex.getCommitHistoryWithFirstParentCommits((CommitDescriptor)existingCommit.get(), 0L);
            List knownCommits = HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)this.inputBranchingLayer);
            HashSet intersection = CollectionUtils.intersectionSet((Collection)storedHistory, (Collection[])new Collection[]{knownCommits});
            if (!intersection.isEmpty()) {
                return Optional.of((CommitDescriptor)Collections.max(intersection));
            }
        }
        return Optional.empty();
    }

    public SchemaAwareStorageSystem getModificationStorageSystem() {
        return this.modificationStorageSystem;
    }

    public void completeAddition(final AdditionInfo rollbackInformation) throws StorageException {
        LOGGER.trace("completeAddition: rollbackInformation={}", (Object)rollbackInformation);
        this.replayCommits(rollbackInformation.timestampByBranch, new IReplayFilter(){

            @Override
            public boolean mayBeReplayed(ParentedCommitDescriptor artificialCommit) {
                return !artificialCommit.equals((Object)rollbackInformation.artificialWriteCommit);
            }

            @Override
            public ParentedCommitDescriptor adjustParent(ParentedCommitDescriptor artificialCommit) {
                CommitDescriptor commitParent = artificialCommit.getFirstParentCommit();
                CommitDescriptor writeParent = rollbackInformation.artificialWriteCommit.getFirstParentCommit();
                if (commitParent != null && commitParent.equals((Object)writeParent)) {
                    return new ParentedCommitDescriptor((CommitDescriptor)artificialCommit, Collections.singletonList(rollbackInformation.artificialWriteCommit));
                }
                return artificialCommit;
            }
        });
        this.commitChanges();
    }

    private static interface IReplayFilter {
        public boolean mayBeReplayed(ParentedCommitDescriptor var1);

        public ParentedCommitDescriptor adjustParent(ParentedCommitDescriptor var1) throws StorageException;
    }

    public static final class AdditionInfo {
        private final Map<String, Long> timestampByBranch;
        private final ParentedCommitDescriptor artificialWriteCommit;

        private AdditionInfo(Map<String, Long> timestampByBranch, ParentedCommitDescriptor writeCommit) {
            this.timestampByBranch = timestampByBranch;
            this.artificialWriteCommit = writeCommit;
        }

        public ParentedCommitDescriptor getArtificialWriteCommit() {
            return this.artificialWriteCommit;
        }

        public String toString() {
            return "AdditionInfo[timestampByBranch=" + this.timestampByBranch.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "@" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "artificialWriteCommit=" + this.artificialWriteCommit.toStringWithParents() + "]";
        }
    }
}

