/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.abaplint;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.findings.FindingReportAnalyzerBase;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class ABAPLintReportReader
extends FindingReportAnalyzerBase {
    public ABAPLintReportReader(IMatchingPathsLookup matchingPathsLookup) {
        super(matchingPathsLookup);
    }

    public ListMap<String, IndexFinding> parseReport(String report, TokenElementIndexCache contentIndexCache) throws ConQATException {
        ListMap findings = new ListMap();
        if (StringUtils.isEmpty((String)report)) {
            return findings;
        }
        JsonNode jsonReport = JsonUtils.deserializeFromJson((String)report);
        ListMap findingsAsJson = new ListMap();
        for (JsonNode finding : jsonReport) {
            String file = finding.get("file").asText();
            if (file.startsWith("./")) {
                file = file.substring(2);
            }
            findingsAsJson.add((Object)file, (Object)finding);
        }
        ArrayList<String> files = new ArrayList<String>((Collection<String>)findingsAsJson.getKeys());
        List<@Nullable TokenElementInfo> tokenElements = contentIndexCache.getValues(files);
        for (int i = 0; i < files.size(); ++i) {
            String file = (String)files.get(i);
            TokenElementInfo tokenElement = tokenElements.get(i);
            if (tokenElement == null) continue;
            LineOffsetConverter converter = new LineOffsetConverter(tokenElement.getText());
            for (JsonNode findingNode : (List)findingsAsJson.getCollection((Object)file)) {
                int startRow = findingNode.at("/start/row").asInt();
                int endRow = findingNode.at("/end/row").asInt();
                int rawStartOffset = findingNode.at("/start/col").asInt() - 1;
                int rawEndOffset = findingNode.at("/end/col").asInt() - 1;
                String checkID = findingNode.get("key").asText();
                IndexFinding finding = new IndexFinding(checkID, "abaplint", findingNode.get("description").asText(), (ElementLocation)new TextRegionLocation(file, converter.getOffset(startRow) + rawStartOffset, converter.getOffset(endRow) + rawEndOffset, startRow, endRow));
                IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)checkID, (Set)EAnalysisTool.ABAPLINT.getSupportedLanguages());
                findings.add((Object)file, (Object)finding);
            }
        }
        return findings;
    }
}

