/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.VisibleForTesting;

public class ClangTidyOutputParser {
    private static final Pattern ISSUE_LINE_PATTERN = Pattern.compile("^(.*):(\\d+):(\\d+):\\s*(warning|error):(.*)\\s*\\[(.*)\\]$");

    public static Optional<ClangTidyResultItem> parseIssue(String line) {
        Matcher m = ISSUE_LINE_PATTERN.matcher(line);
        if (m.matches()) {
            EClangTidyResultCategory type = EClangTidyResultCategory.GENERIC_ERROR_OR_WARNING;
            if ("error".equals(m.group(4))) {
                type = EClangTidyResultCategory.ERROR;
            }
            String sourceFile = m.group(1);
            int lineNumber = Integer.parseInt(m.group(2));
            int lineColumn = Integer.parseInt(m.group(3));
            String message = m.group(5).trim();
            String checkId = m.group(6);
            return Optional.of(new ClangTidyResultItem(type, sourceFile, lineNumber, lineColumn, message, checkId));
        }
        return Optional.empty();
    }

    public static enum EClangTidyResultCategory {
        ERROR,
        GENERIC_ERROR_OR_WARNING;

    }

    public static class ClangTidyResultItem {
        public final EClangTidyResultCategory type;
        public final String sourceFile;
        public final int lineNumber;
        public final int lineColumn;
        public final String message;
        public final String checkId;

        @VisibleForTesting
        public ClangTidyResultItem(EClangTidyResultCategory type, String sourceFile, int lineNumber, int lineColumn, String message, String checkId) {
            this.type = type;
            this.sourceFile = sourceFile;
            this.lineNumber = lineNumber;
            this.lineColumn = lineColumn;
            this.message = message;
            this.checkId = checkId;
        }
    }
}

