/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap.metadata;

import com.teamscale.index.gitbridge.abap.metadata.AbapGitMetaDataWriterBase;
import com.teamscale.index.gitbridge.abap.metadata.BdefWriter;
import com.teamscale.index.gitbridge.abap.metadata.ClasWriter;
import com.teamscale.index.gitbridge.abap.metadata.DclsWriter;
import com.teamscale.index.gitbridge.abap.metadata.DdlsWriter;
import com.teamscale.index.gitbridge.abap.metadata.DdlxWriter;
import com.teamscale.index.gitbridge.abap.metadata.EnhoWriter;
import com.teamscale.index.gitbridge.abap.metadata.IAbapGitMetaDataWriter;
import com.teamscale.index.gitbridge.abap.metadata.InterfWriter;
import com.teamscale.index.gitbridge.abap.metadata.ProgDirWriter;
import com.teamscale.index.gitbridge.abap.metadata.SrvdWriter;
import java.util.Optional;
import org.conqat.engine.abap.EAbapObjectType;

public class AbapGitMetaDataWriterFactory {
    public static Optional<IAbapGitMetaDataWriter> createWriter(EAbapObjectType objectType) {
        AbapGitMetaDataWriterBase writer = switch (objectType) {
            case EAbapObjectType.CLAS -> new ClasWriter();
            case EAbapObjectType.INTF -> new InterfWriter();
            case EAbapObjectType.PROG, EAbapObjectType.FUGR -> new ProgDirWriter();
            case EAbapObjectType.DDLS -> new DdlsWriter();
            case EAbapObjectType.DDLX -> new DdlxWriter();
            case EAbapObjectType.DCLS -> new DclsWriter();
            case EAbapObjectType.SRVD -> new SrvdWriter();
            case EAbapObjectType.BDEF -> new BdefWriter();
            case EAbapObjectType.ENHO -> new EnhoWriter();
            default -> null;
        };
        return Optional.ofNullable(writer);
    }
}

