/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.index.migration.finding.ConfigurationOptionDeletion;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import java.util.List;

public class MigrationVersion170ExceptionCatching {
    public static final List<IJsonMigration> MIGRATIONS = List.of(MigrationVersion170ExceptionCatching::migrate, new ConfigurationOptionDeletion("cqse-catch-null-pointer-exception", "Imprecise Handling"), new ConfigurationOptionReplacement("cqse-java-catch-unwanted-exception", "Imprecise Handling", "cqse-java-catch-unwanted-exception", "Discouraged APIs"), new ConfigurationOptionReplacement("Unwanted catch of exception (Java): Exception names", "Imprecise Handling", "Unwanted catch of exception (Java): Exception names", "Discouraged APIs"), new ConfigurationOptionReplacement("cqse-cs-catch-unwanted-exception", "Imprecise Handling", "cqse-cs-catch-unwanted-exception", "Discouraged APIs"), new ConfigurationOptionReplacement("Unwanted catch of exception (C#): Exception names", "Imprecise Handling", "Unwanted catch of exception (C#): Exception names", "Discouraged APIs"));

    private static void migrate(ObjectNode root) {
        JsonNode nullPointerNode = root.findValue("cqse-catch-null-pointer-exception");
        if (nullPointerNode == null) {
            return;
        }
        ArrayNode languages = (ArrayNode)root.findValue("languages");
        for (JsonNode languageNode : languages) {
            String language = languageNode.textValue();
            ObjectNode parent = root.findParent("cqse-catch-null-pointer-exception");
            String color = nullPointerNode.asText();
            if (language.equals("JAVA")) {
                String exceptions = String.join((CharSequence)",", "NullPointerException", "java.lang.NullPointerException");
                parent.set("cqse-java-catch-unwanted-exception", (JsonNode)new TextNode(color));
                parent.set("Unwanted catch of exception (Java): Exception names", (JsonNode)new TextNode(exceptions));
                continue;
            }
            if (!language.equals("CS")) continue;
            parent.set("cqse-cs-catch-unwanted-exception", (JsonNode)new TextNode(color));
            parent.set("Unwanted catch of exception (C#): Exception names", (JsonNode)new TextNode("NullReferenceException"));
        }
    }
}

