/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Collections;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion38SkipVotingOptionMigration {
    private static final Set<String> VOTING_CONNECTOR_LIST = Set.of(ERepositoryConnector.GIT.getReadableName(), ERepositoryConnector.BITBUCKET.getReadableName(), ERepositoryConnector.GITHUB.getReadableName(), ERepositoryConnector.GITLAB.getReadableName(), ERepositoryConnector.AZURE_DEVOPS_GIT.getReadableName(), ERepositoryConnector.SCM_MANAGER.getReadableName(), ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST.getReadableName());

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion38SkipVotingOptionMigration::migrateSkipVotingOption);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateSkipVotingOption(ConnectorConfiguration connectorConfiguration) {
        if (!VOTING_CONNECTOR_LIST.contains(connectorConfiguration.getRawType())) {
            connectorConfiguration.removeOptions(Collections.singleton("Skip Voting on merge requests without relevant changes"));
        }
        return connectorConfiguration;
    }
}

