/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.index.naming.ENamingConventionTokenClass;
import com.teamscale.index.naming.NamingConventionAnalyzer;
import com.teamscale.index.naming.NamingConventionGroup;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class JavaScriptNamingConventionAnalyzer
extends NamingConventionAnalyzer {
    private static final Set<String> FUNCTIONAL_COMPONENT_DECLARATION_SUBTYPE_NAMES = Set.of("local variable", "named function", "assigned function", "assigned lambda", "attribute function");
    private static final Set<String> REACT_COMPONENTS = Set.of("React", "ReactNode", "ReactText", "ReactChild", "ReactElement", "ReactFragment", "ReactPortal");

    public JavaScriptNamingConventionAnalyzer() {
        super(ELanguage.JAVASCRIPT);
    }

    @Override
    protected void checkStatement(TokenElementInfo element, ShallowEntity entity) {
        if (!entity.getSubtype().equals("local variable")) {
            super.checkStatement(element, entity);
            return;
        }
        UnmodifiableList tokens = entity.includedTokens();
        ArrayList<IToken> names = new ArrayList<IToken>();
        if (tokens.size() > 1 && ETokenType.LBRACE.matches((IToken)tokens.get(1))) {
            JavaScriptNamingConventionAnalyzer.getNamesWithinArray((List<IToken>)tokens, names);
        } else if (tokens.size() > 1 && ETokenType.LBRACK.matches((IToken)tokens.get(1))) {
            JavaScriptNamingConventionAnalyzer.getNamesWithinObject((List<IToken>)tokens, names);
        } else {
            names.addAll(ShallowParsingUtils.extractVariableNameTokens((List)tokens));
        }
        for (IToken token : names) {
            this.processTokenName(entity, element, token);
        }
    }

    private void processTokenName(ShallowEntity entity, TokenElementInfo element, IToken token) {
        if (JavaScriptNamingConventionAnalyzer.isFunctionalComponent(entity, token.getText())) {
            this.checkTokenName(element, token, ENamingConventionTokenClass.FUNCTIONAL_COMPONENTS);
        } else if (JavaScriptNamingConventionAnalyzer.isGlobal(entity) && this.isConstant(entity)) {
            this.checkTokenName(element, token, ENamingConventionTokenClass.CONSTANTS);
        } else if (JavaScriptNamingConventionAnalyzer.isGlobal(entity)) {
            this.checkTokenName(element, token, ENamingConventionTokenClass.GLOBAL_VARIABLES);
        } else {
            this.checkTokenName(element, token, ENamingConventionTokenClass.LOCAL_VARIABLES);
        }
    }

    @Override
    protected void checkMethod(TokenElementInfo element, ShallowEntity entity) {
        super.checkMethod(element, entity);
        if (JavaScriptNamingConventionAnalyzer.isFunctionalComponent(entity, entity.getName())) {
            this.checkEntityName(element, entity, NamingConventionGroup.create(this.language, ENamingConventionTokenClass.FUNCTIONAL_COMPONENTS));
        }
    }

    @Override
    protected boolean isIgnoredMethodType(ShallowEntity entity) {
        return super.isIgnoredMethodType(entity) || JavaScriptNamingConventionAnalyzer.isFunctionalComponent(entity, entity.getName()) || JavaScriptNamingConventionAnalyzer.isDefinedInJavaScriptObjectLiteral(entity);
    }

    private static boolean isDefinedInJavaScriptObjectLiteral(ShallowEntity entity) {
        return "attribute function".equals(entity.getSubtype()) && entity.getParent() != null && entity.getParent().getType() != EShallowEntityType.TYPE;
    }

    private static boolean isFunctionalComponent(ShallowEntity entity, String name) {
        return !StringUtils.isEmpty((String)name) && Character.isUpperCase(name.charAt(0)) && JavaScriptNamingConventionAnalyzer.isInJsxFile(entity) && FUNCTIONAL_COMPONENT_DECLARATION_SUBTYPE_NAMES.contains(entity.getSubtype()) && entity.includedTokens().stream().anyMatch(JavaScriptNamingConventionAnalyzer::indicatesFunctionalComponent);
    }

    private static boolean isInJsxFile(ShallowEntity entity) {
        if (entity.isEmpty()) {
            return false;
        }
        String originId = ((IToken)entity.includedTokens().getFirst()).getOriginId();
        return originId == null || originId.toLowerCase().endsWith(".jsx") || originId.toLowerCase().endsWith(".tsx");
    }

    private static boolean indicatesFunctionalComponent(IToken token) {
        return token.getType() == ETokenType.JSX || token.getText().equals("children") || token.getText().matches("use[A-Z].*") || token.getText().equals("JSX") || REACT_COMPONENTS.contains(token.getText());
    }

    private static void getNamesWithinObject(List<IToken> tokens, List<IToken> namingTokensAccumulator) {
        for (List attribute : ShallowParsingUtils.splitOnNonNestedCommas((List)TokenStreamUtils.tokensBetweenWithNesting(tokens, (ETokenType)ETokenType.LBRACK, (ETokenType)ETokenType.RBRACK))) {
            if (TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER})) {
                namingTokensAccumulator.add((IToken)attribute.getFirst());
                continue;
            }
            if (TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOT, ETokenType.DOT, ETokenType.IDENTIFIER})) {
                namingTokensAccumulator.add((IToken)attribute.get(3));
                continue;
            }
            if (TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOT, ETokenType.DOT, ETokenType.LBRACE})) {
                JavaScriptNamingConventionAnalyzer.getNamesWithinArray(attribute, namingTokensAccumulator);
                continue;
            }
            if (!TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOT, ETokenType.DOT, ETokenType.LBRACK})) continue;
            JavaScriptNamingConventionAnalyzer.getNamesWithinObject(attribute, namingTokensAccumulator);
        }
    }

    private static void getNamesWithinArray(List<IToken> tokens, List<IToken> namingTokensAccumulator) {
        for (List attribute : ShallowParsingUtils.splitOnNonNestedCommas((List)TokenStreamUtils.tokensBetweenWithNesting(tokens, (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE))) {
            if (TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER})) {
                namingTokensAccumulator.add((IToken)attribute.get(2));
                continue;
            }
            if (TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOT, ETokenType.DOT, ETokenType.IDENTIFIER})) {
                namingTokensAccumulator.add((IToken)attribute.get(3));
                continue;
            }
            if (!TokenStreamUtils.startsWith((List)attribute, (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.RBRACK, ETokenType.COLON, ETokenType.IDENTIFIER})) continue;
            namingTokensAccumulator.add((IToken)attribute.get(4));
        }
    }
}

