/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.external.result.ExternalAnalysisResultMultiFileRangeCoverage;
import com.teamscale.index.report.result.processor.CoverageUnitTempIndex;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.testimpact.CoverageUnitChangeEntry;
import com.teamscale.index.testimpact.CoverageUnitChangeIndex;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultMultiFileRangeCoverageProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultMultiFileRangeCoverage> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    CoverageUnitTempIndex coverageUnitTempIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CoverageUnitChangeIndex coverageUnitChangeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CoverageUnitToMethodsMapIndex newCoverageUnitToMethodsMapIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ImpactedTestsIndex impactedTestsIndex;
    private final Map<String, PairList<String, MultiFileRangeCoverageInfo>> multiFileRangeCoveragesByPartition = new HashMap<String, PairList<String, MultiFileRangeCoverageInfo>>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isTestExecutionPath() || uniformPath.isExecutionUnit();
    }

    @Override
    public Class<ExternalAnalysisResultMultiFileRangeCoverage> getResultClass() {
        return ExternalAnalysisResultMultiFileRangeCoverage.class;
    }

    @Override
    public boolean isPartOfPartialReport(String partition, ExternalAnalysisResultMultiFileRangeCoverage result) {
        return result.isPartOfPartialReport();
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultMultiFileRangeCoverage analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        MultiFileRangeCoverageInfo multiFileRangeCoverageInfo = analysisResult.getData();
        this.multiFileRangeCoveragesByPartition.computeIfAbsent(partition, x -> new PairList()).add((Object)uniformPath.toString(), (Object)ExternalAnalysisResultMultiFileRangeCoverageProcessor.fixCoverage(multiFileRangeCoverageInfo, resultsCommit));
        return true;
    }

    private static MultiFileRangeCoverageInfo fixCoverage(MultiFileRangeCoverageInfo coverageInfo, CommitDescriptor commit) {
        coverageInfo.setTimestamp(commit.getTimestamp());
        return coverageInfo;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        for (Map.Entry<String, PairList<String, MultiFileRangeCoverageInfo>> partitionAndMultiFileRangeCoverage : this.multiFileRangeCoveragesByPartition.entrySet()) {
            this.coverageUnitTempIndex.addCoverage(partitionAndMultiFileRangeCoverage.getKey(), partitionAndMultiFileRangeCoverage.getValue());
        }
        CoverageUnitChangeEntry coverageUnitChangeEntry = this.coverageUnitChangeIndex.getExistingOrEmptyEntry(commit);
        coverageUnitChangeEntry.addChangedTests(this.getCoverageUnitPartitionAndPaths());
        this.coverageUnitChangeIndex.setEntry(coverageUnitChangeEntry);
    }

    private Set<PartitionAndPath> getCoverageUnitPartitionAndPaths() {
        HashSet<PartitionAndPath> coverageUnits = new HashSet<PartitionAndPath>();
        for (Map.Entry<String, PairList<String, MultiFileRangeCoverageInfo>> partitionAndMultiFileRangeCoverage : this.multiFileRangeCoveragesByPartition.entrySet()) {
            String partition = partitionAndMultiFileRangeCoverage.getKey();
            for (String testPath : partitionAndMultiFileRangeCoverage.getValue().getFirstList()) {
                coverageUnits.add(PartitionAndPath.forCoverageUnit((String)partition, (String)testPath));
            }
        }
        return coverageUnits;
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        ArrayList<PartitionAndPath> deletedPartitionAndPathsList = new ArrayList<PartitionAndPath>(deletedPartitionAndPaths);
        this.newCoverageUnitToMethodsMapIndex.deleteCoverageUnits(deletedPartitionAndPathsList);
        this.impactedTestsIndex.removeCoverageUnits(deletedPartitionAndPathsList);
        CoverageUnitChangeEntry testChangeEntry = this.coverageUnitChangeIndex.getExistingOrEmptyEntry(commit);
        testChangeEntry.addDeletedCoverageUnits(deletedPartitionAndPaths);
        this.coverageUnitChangeIndex.setEntry(testChangeEntry);
    }

    @Override
    public void reset() {
        this.multiFileRangeCoveragesByPartition.clear();
    }
}

