/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.index.external.result.ExternalAnalysisResultTestExecution;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.tests.SpecItemTestReferenceIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class ExternalAnalysisResultTestExecutionProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultTestExecution> {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TestExecutionIndex previousTestExecutionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestExecutionIndex testExecutionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemTestReferenceIndex specItemTestReferenceIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex projectMetaIndex;
    private final Map<String, Map<String, TestExecution>> newTestExecutions = new HashMap<String, Map<String, TestExecution>>();
    private final List<PartitionAndPath> updatedPartitionAndPaths = new ArrayList<PartitionAndPath>();
    private final Set<UniformPath> duplicateTestExecutionPaths = new HashSet<UniformPath>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isTestExecutionPath();
    }

    @Override
    public Class<ExternalAnalysisResultTestExecution> getResultClass() {
        return ExternalAnalysisResultTestExecution.class;
    }

    @Override
    public boolean isPartOfPartialReport(String partition, ExternalAnalysisResultTestExecution result) {
        return result.isPartOfPartialReport();
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultTestExecution analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        Map<String, TestExecution> executionsByPath = this.getStringTestExecutionMap(partition);
        TestExecution testExecution = analysisResult.getData().copyWithUniformPath(uniformPath);
        String uniformPathString = uniformPath.toString();
        if (executionsByPath.containsKey(uniformPathString)) {
            this.duplicateTestExecutionPaths.add(uniformPath);
        }
        executionsByPath.merge(uniformPathString, testExecution, TestExecution::pickFromFlickering);
        this.updatedPartitionAndPaths.add(new PartitionAndPath(partition, uniformPath));
        return true;
    }

    private @NonNull Map<String, TestExecution> getStringTestExecutionMap(String partition) {
        return this.newTestExecutions.computeIfAbsent(partition, p -> new HashMap());
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        if (!this.duplicateTestExecutionPaths.isEmpty()) {
            LOGGER.debug("Encountered test executions with duplicate uniform paths, we assume that those are flickers and hence we picked the executions with the better result: {}", new Supplier[]{() -> this.duplicateTestExecutionPaths.stream().sorted().map(UniformPath::toString).collect(Collectors.joining("\n- ", "- ", ""))});
        }
        if (this.newTestExecutions.isEmpty()) {
            return;
        }
        List<TestExecutionWithPartition> previousTestExecutions = this.previousTestExecutionIndex.getTestExecutionsForPartitionAndPaths(this.updatedPartitionAndPaths);
        this.deleteDataInPartitionsWithoutPreviousReports();
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((MetaIndex)this.projectMetaIndex);
        Map<String, Pattern> connectorSpecItemIdPatterns = ExternalAnalysisResultTestExecutionProcessor.getConnectorSpecItemIdPatterns(projectConfiguration);
        PairList testExecutionsWithPartition = new PairList();
        HashMap<TeamscaleIssueId, Set<PartitionAndPath>> verifiedTestsBySpecItem = new HashMap<TeamscaleIssueId, Set<PartitionAndPath>>();
        for (int i = 0; i < this.updatedPartitionAndPaths.size(); ++i) {
            List<CommitDescriptor> previousReportCommits = Collections.emptyList();
            if (previousTestExecutions.get(i) != null) {
                previousReportCommits = Collections.singletonList(previousTestExecutions.get(i).getCommit());
            }
            PartitionAndPath partitionAndPath = this.updatedPartitionAndPaths.get(i);
            TestExecution testExecution = this.newTestExecutions.get(partitionAndPath.getPartition()).get(partitionAndPath.getUniformPath());
            TestExecutionWithPartition executionWithPartition = new TestExecutionWithPartition(testExecution, partitionAndPath.getPartition(), commit, previousReportCommits);
            testExecutionsWithPartition.add((Object)partitionAndPath, (Object)executionWithPartition);
            ExternalAnalysisResultTestExecutionProcessor.addAssociatedSpecItems(partitionAndPath, executionWithPartition, verifiedTestsBySpecItem, connectorSpecItemIdPatterns, projectConfiguration);
        }
        this.testExecutionIndex.setTestExecutions((PairList<PartitionAndPath, TestExecutionWithPartition>)testExecutionsWithPartition);
        this.specItemTestReferenceIndex.setTestReferences(verifiedTestsBySpecItem);
    }

    private void deleteDataInPartitionsWithoutPreviousReports() throws StorageException {
        this.testExecutionIndex.purgeFromOtherBranches(this.updatedPartitionAndPaths.stream().map(PartitionAndPath::getPartition).collect(Collectors.toSet()));
    }

    private static @NonNull Map<String, Pattern> getConnectorSpecItemIdPatterns(ProjectConfiguration projectConfiguration) {
        HashMap<String, Pattern> connectorToSpecItemIdPattern = new HashMap<String, Pattern>();
        if (projectConfiguration == null) {
            return connectorToSpecItemIdPattern;
        }
        UnmodifiableList connectorConfigurations = projectConfiguration.getConnectors();
        for (ConnectorConfiguration connector : connectorConfigurations) {
            String pattern = connector.getOptionValue("Specification item ID pattern");
            if (pattern == null) continue;
            connectorToSpecItemIdPattern.put(connector.getIdentifier(), Pattern.compile(pattern));
        }
        return connectorToSpecItemIdPattern;
    }

    private static void addAssociatedSpecItems(PartitionAndPath partitionAndPath, TestExecutionWithPartition executionWithPartition, Map<TeamscaleIssueId, Set<PartitionAndPath>> verifiedTestsBySpecItem, Map<String, Pattern> connectorToSpecItemIdPattern, ProjectConfiguration projectConfiguration) {
        List associatedSpecItems = executionWithPartition.getTestExecution().getAssociatedSpecItems();
        if (associatedSpecItems == null) {
            return;
        }
        for (String specItem : associatedSpecItems) {
            for (TeamscaleIssueId specItemId : ExternalAnalysisResultTestExecutionProcessor.retrieveInternalSpecItemIds(specItem, connectorToSpecItemIdPattern, projectConfiguration)) {
                verifiedTestsBySpecItem.computeIfAbsent(specItemId, ignored -> new HashSet()).add(partitionAndPath);
            }
        }
    }

    @VisibleForTesting
    public static @NonNull Set<TeamscaleIssueId> retrieveInternalSpecItemIds(String externalId, Map<String, Pattern> connectorToSpecItemIdPattern, ProjectConfiguration projectConfiguration) {
        if (projectConfiguration == null) {
            throw new IllegalStateException("Test Execution report upload: No project configuration found when trying to retrieve the requirements connector(s)");
        }
        if (ExternalAnalysisResultTestExecutionProcessor.isValidInternalId(externalId)) {
            if (ExternalAnalysisResultTestExecutionProcessor.connectorExists(externalId, projectConfiguration)) {
                return Set.of(TeamscaleIssueId.fromInternalId((String)externalId));
            }
            return Set.of();
        }
        HashSet<TeamscaleIssueId> specItemIds = new HashSet<TeamscaleIssueId>();
        for (Map.Entry<String, Pattern> entry : connectorToSpecItemIdPattern.entrySet()) {
            TeamscaleIssueId internalId;
            String connectorId = entry.getKey();
            Pattern specItemPattern = entry.getValue();
            Matcher specItemMatcher = specItemPattern.matcher(externalId);
            CCSMAssert.isTrue((specItemMatcher.groupCount() > 0 ? 1 : 0) != 0, () -> String.format("Expected regular expression \"%s\" to contain at least one capturing group", specItemPattern.pattern()));
            if (!specItemMatcher.find() || !ExternalAnalysisResultTestExecutionProcessor.isValidInternalId((internalId = new TeamscaleIssueId(connectorId, specItemMatcher.group(1))).getInternalId()) || !ExternalAnalysisResultTestExecutionProcessor.connectorExists(internalId.getInternalId(), projectConfiguration)) continue;
            specItemIds.add(internalId);
        }
        return specItemIds;
    }

    private static boolean isValidInternalId(String internalId) {
        return TeamscaleIssueId.isValidInternalId((String)internalId);
    }

    private static boolean connectorExists(String internalId, ProjectConfiguration projectConfiguration) {
        String connectorId = TeamscaleIssueId.fromInternalId((String)internalId).getConnectorId();
        return projectConfiguration.getConnectors().stream().anyMatch(connector -> connector.getIdentifier().equals(connectorId));
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        this.testExecutionIndex.removeTestExecutions(deletedPartitionAndPaths);
        this.specItemTestReferenceIndex.removeTestReferences(deletedPartitionAndPaths);
    }

    @Override
    public void reset() {
        this.newTestExecutions.clear();
        this.updatedPartitionAndPaths.clear();
    }
}

