/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.roslyn;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.tools.message.CSCompilerWarningsMessageManager;
import com.teamscale.index.configuration.tools.message.ExternalAnalysisToolMessageManager;
import com.teamscale.index.configuration.tools.message.FxCopMessageManager;
import com.teamscale.index.configuration.tools.message.IMessageManager;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class RoslynMessageManagerProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern RULE_PREFIX_PATTERN = Pattern.compile("([A-Z]{2,3})[0-9]+");
    private final Map<String, IMessageManager> rulePrefixToMessageManager;

    public RoslynMessageManagerProvider() throws ProjectConfigurationException {
        CCSMAssert.isNotNull((Object)LOGGER, (String)"Message manager provider requires a non-null logger.");
        this.rulePrefixToMessageManager = new HashMap<String, IMessageManager>();
        this.rulePrefixToMessageManager.put(CSCompilerWarningsMessageManager.getInstance().getRulePrefix(), CSCompilerWarningsMessageManager.getInstance());
        this.rulePrefixToMessageManager.put("CA", FxCopMessageManager.getInstance());
    }

    public IMessageManager getMessageManger(String ruleId, ExternalFindingsGroupDescriptionIndex externalFindingsIndex) throws ConQATException {
        Optional<String> prefix = RoslynMessageManagerProvider.getPrefix(ruleId);
        IMessageManager messageManager = null;
        if (prefix.isPresent()) {
            messageManager = this.rulePrefixToMessageManager.get(prefix.get());
        }
        if (messageManager == null || !messageManager.hasRule(ruleId)) {
            EAnalysisTool tool = EAnalysisTool.ROSLYN;
            messageManager = ExternalAnalysisToolMessageManager.getInstance(tool, externalFindingsIndex.getDescriptions(tool));
        }
        if (messageManager == null || !messageManager.hasRule(ruleId)) {
            return null;
        }
        return messageManager;
    }

    private static Optional<String> getPrefix(String ruleId) {
        Matcher matcher = RULE_PREFIX_PATTERN.matcher(ruleId);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        LOGGER.debug("Rule '{}' doesn't match the expected pattern '{}'.", (Object)ruleId, (Object)RULE_PREFIX_PATTERN.pattern());
        return Optional.empty();
    }
}

