/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.jspecify.annotations.NonNull;

public final class ArtifactIncludeExcludePatterns {
    private final List<Pattern> includedNamesPatterns;
    private final List<Pattern> excludedPathsPatterns;

    public static @NonNull ArtifactIncludeExcludePatterns createWithExcludedPathsPatterns(@NonNull List<String> excludedPathsPatterns) {
        return new ArtifactIncludeExcludePatterns(List.of("**"), excludedPathsPatterns);
    }

    public static @NonNull ArtifactIncludeExcludePatterns createWithIncludedNamesPatterns(@NonNull List<String> includedNamesPatterns) {
        return new ArtifactIncludeExcludePatterns(includedNamesPatterns, (List<String>)CollectionUtils.emptyList());
    }

    public static @NonNull ArtifactIncludeExcludePatterns createWithIncludedNamesAndExcludedPathsPatterns(@NonNull List<String> includedNamesPatterns, @NonNull List<String> excludedPathsPatterns) {
        return new ArtifactIncludeExcludePatterns(includedNamesPatterns, excludedPathsPatterns);
    }

    public static @NonNull ArtifactIncludeExcludePatterns createWithDefaultPatterns() {
        return ArtifactIncludeExcludePatterns.createWithExcludedPathsPatterns((List<String>)CollectionUtils.emptyList());
    }

    private ArtifactIncludeExcludePatterns(List<String> includedNamesPatterns, List<String> excludedPathsPatterns) {
        Objects.requireNonNull(includedNamesPatterns);
        Objects.requireNonNull(excludedPathsPatterns);
        this.includedNamesPatterns = CollectionUtils.map(includedNamesPatterns, pattern -> AntPatternUtils.convertPattern((String)pattern, (boolean)false));
        this.excludedPathsPatterns = CollectionUtils.map(excludedPathsPatterns, pattern -> AntPatternUtils.convertPattern((String)pattern, (boolean)false));
    }

    public @NonNull List<ArtifactStoreItemData> filterArtifacts(@NonNull List<ArtifactStoreItemData> artifacts) {
        return CollectionUtils.filter(artifacts, this::matchesIncludesAndExcludes);
    }

    private boolean matchesIncludesAndExcludes(ArtifactStoreItemData item) {
        return this.isIncluded(item) && !this.isExcluded(item);
    }

    private boolean isIncluded(ArtifactStoreItemData item) {
        return this.includedNamesPatterns.stream().anyMatch(includePattern -> includePattern.matcher(item.name).matches());
    }

    private boolean isExcluded(ArtifactStoreItemData item) {
        return this.excludedPathsPatterns.stream().anyMatch(excludePattern -> excludePattern.matcher(item.getFullPath()).matches());
    }
}

