/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.BranchPointerHistoryIndex;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.committree.NopBranchRenameHandler;
import com.teamscale.index.repository.git.BranchHeadRef;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitCommitGraphNode;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.GitPreStartCommitsSupport;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import com.teamscale.index.repository.git.common.SystemPropertyUtils;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDebugDumperFactory;
import com.teamscale.index.repository.git.debug_dump.dump.IGitRepositoryDebugDumper;
import com.teamscale.index.repository.git.debug_dump.replay.GitMainRepositoryMock;
import com.teamscale.index.repository.git.labeling.GitBranchPrioritizer;
import com.teamscale.index.repository.git.labeling.PathBuildingBranchLabeler;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jpountz.xxhash.StreamingXXHash64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.transport.RefSpec;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GitRepositoryConnection
extends RepositoryConnectionBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FAILED_FETCH_LIMIT_PROPERTY_NAME = "com.teamscale.failed-fetch-limit";
    private static final int FAILED_FETCH_LIMIT_DEFAULT_VALUE = 5;
    @VisibleForTesting
    static final String MERGE_REQUEST_HEAD_REFS_PATTERN = "refs/remotes/merge-requests/*/head";
    protected GitRepositoryConnectorParameterStep gitParameters;
    protected Boolean keepResurrectedBranchHistory = (Boolean)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getValue();
    private static final Duration MAXIMUM_TIME_BETWEEN_COMMIT_TREE_EXPANSIONS = DurationUtils.ONE_HOUR;
    private final TeamscaleGitCredentialsProvider credentials;
    private final Instant analysisStart;
    private final Instant analysisEnd;
    private final Path cloneDirectory;
    protected final GitMainRepository repository;
    private String lastSynchronizedRevision = null;
    private final GitBranchPrioritizer branchPrioritizer;
    private PathBuildingBranchLabeler branchLabeler;
    private final IGitRepositoryDebugDumper repoDumper;
    private final GitPreStartCommitsSupport preStartCommitsSupport;
    protected boolean convertSubmoduleSshToHttpsUrl;

    public GitRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, GitCredentials gitCredentials, ICancelable cancelable) throws RepositoryException {
        this(connectorBaseParameterStep, gitParameterStep, gitCredentials, cancelable, false, false);
    }

    public GitRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, GitCredentials gitCredentials, ICancelable cancelable, boolean convertSubmoduleSshToHttpsUrl) throws RepositoryException {
        this(connectorBaseParameterStep, gitParameterStep, gitCredentials, cancelable, convertSubmoduleSshToHttpsUrl, false);
    }

    public GitRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, GitCredentials gitCredentials, ICancelable cancelable, boolean convertSubmoduleSshToHttpsUrl, boolean mockGitMainRepository) throws RepositoryException {
        super(connectorBaseParameterStep);
        this.repoDumper = GitRepositoryDebugDumperFactory.createDebugDumper(connectorBaseParameterStep, gitParameterStep);
        this.gitParameters = gitParameterStep;
        this.credentials = GitUtils.createCredentialsProvider(gitCredentials.username(), gitCredentials.password(), gitCredentials.privateKeyOption());
        this.convertSubmoduleSshToHttpsUrl = convertSubmoduleSshToHttpsUrl;
        this.cloneDirectory = gitParameterStep.getRepositoryCloneDirectory();
        this.repository = mockGitMainRepository ? new GitMainRepositoryMock(this) : new GitMainRepository(this, gitCredentials.repositoryPath(), cancelable);
        this.branchPrioritizer = new GitBranchPrioritizer(connectorBaseParameterStep.getDefaultBranchName(), gitParameterStep.getImportantBranchPatterns());
        this.analysisStart = this.computeAnalysisStartInSecondPrecision(connectorBaseParameterStep);
        this.analysisEnd = this.getInstantForEndDateOrRevision(connectorBaseParameterStep.getEndDateOrRevision());
        this.preStartCommitsSupport = new GitPreStartCommitsSupport(this.gitParameters.getGitInfoIndex(), this.getDefaultBranchName());
    }

    private Instant computeAnalysisStartInSecondPrecision(RepositoryConnectorBaseParameterStep connectorBaseParameterStep) throws RepositoryException {
        Instant analysisStart = this.getInstantForStartDateOrRevision(connectorBaseParameterStep.getStartDateOrRevision(), connectorBaseParameterStep.getMinimalStartTimestamp());
        long millisOffset = analysisStart.toEpochMilli() % 1000L;
        if (millisOffset == 0L) {
            return analysisStart;
        }
        Instant analysisStartInSeconds = analysisStart.minusMillis(millisOffset);
        LOGGER.warn("Analysis start {} is in millisecond precision but will be rounded down to {}.", (Object)analysisStart, (Object)analysisStartInSeconds);
        return analysisStartInSeconds;
    }

    public Path getCloneDirectory() {
        return this.cloneDirectory;
    }

    public TeamscaleGitCredentialsProvider getCredentials() {
        return this.credentials;
    }

    Repository getRepository() {
        return this.repository.getRepository();
    }

    public GitMainRepository getMainRepository() {
        return this.repository;
    }

    public Instant getAnalysisStart() {
        return this.analysisStart;
    }

    protected Instant getAnalysisEnd() {
        return this.analysisEnd;
    }

    public GitBranchPrioritizer getBranchPrioritizer() {
        return this.branchPrioritizer;
    }

    @Override
    protected Optional<Long> convertRevisionToTimestamp(String revision) throws RepositoryException {
        this.synchronizeIfNecessary(revision);
        return this.repository.convertRevisionToTimestamp(revision);
    }

    @Override
    public String getLocationDescription() throws RepositoryException {
        return this.repository.getLocationDescription();
    }

    @Override
    public boolean isCommitTreeExpansionNeeded() throws RepositoryException {
        try {
            return this.gitParameters.getGitInfoIndex().isCommitTreeExpansionNeeded();
        }
        catch (StorageException e) {
            throw new RepositoryException("Reading expansion info failed", (Throwable)e);
        }
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(IChangeRetrieverCommitTree commitTree) throws RepositoryException, RescheduleRequestedException {
        LOGGER.traceEntry("Expanding commit nodes for {}.", new Object[]{commitTree});
        this.doSynchronizeAndRescheduleIfNecessary();
        try {
            this.clearGitInfoIndexIfDefaultBranchChanged();
            if (this.shouldSkipCommitTreeExpansion((ICommitTree)commitTree)) {
                return (CommitTreeExpansionResult)LOGGER.traceExit("Skipped commit tree expansion for {}.", (Object)CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(false).build());
            }
            if (commitTree.getAllNodes().isEmpty()) {
                this.gitParameters.getGitInfoIndex().resetInitialDefaultBranchRootRevision();
            }
            Map<String, CommitGraphNode> nodesByName = this.runPathBuildingAlgorithmAndPersistResults(commitTree);
            this.onPreFilterGitTree(nodesByName);
            this.filterExcludedBranches(nodesByName);
            this.filterNodesAfterAnalysisEnd(nodesByName);
            this.onPostFilterGitTree(nodesByName);
            Set<ICommitTreeNode> addedNodes = this.insertNewNodesIntoCommitTree(commitTree, nodesByName, this.getExistingCommitsOrRaiseRollbackException((ICommitTree)commitTree, nodesByName));
            this.synchronizeSubModules(nodesByName);
            this.updateBranchPointerIndexFromGitRepository(nodesByName);
            this.skipExpansionsUntilNextChange();
            this.storeLastExpansionTimestamp();
            this.performDebugDumpIfRequested();
            return (CommitTreeExpansionResult)LOGGER.traceExit("Expanded commit tree {}.", (Object)CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).withAddedNodes(addedNodes).build());
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void performDebugDumpIfRequested() throws StorageException {
        GitRepositoryInfoIndex gitInfoIndex = this.gitParameters.getGitInfoIndex();
        if (gitInfoIndex.isDebugDumpRequested()) {
            LOGGER.info("Performing a full git debug dump due to user request");
            this.repoDumper.performDump();
            gitInfoIndex.setDebugDumpRequested(false);
        }
    }

    protected void filterExcludedBranches(Map<String, CommitGraphNode> nodesByName) throws StorageException {
        int totalNodesBefore = nodesByName.size();
        LOGGER.trace("Filter {} node(s) to only contain commits on not excluded branches.", (Object)totalNodesBefore);
        CommitGraphNode.topSort(nodesByName.values()).stream().filter(node -> !this.isBranchNameIncludedOrDefaultBranch(node.getBranchName())).forEach(node -> {
            LOGGER.trace("Deleting node on excluded branch: {}", node);
            GitRepositoryConnection.deleteNode(nodesByName, node);
        });
        LOGGER.trace("Filtered out {} nodes on excluded branches.", new Supplier[]{() -> totalNodesBefore - nodesByName.size()});
    }

    private void filterNodesAfterAnalysisEnd(Map<String, CommitGraphNode> nodesByName) {
        int totalNodesBefore = nodesByName.size();
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = nodesByName::size;
        supplierArray[1] = this::getAnalysisEnd;
        LOGGER.trace("Filter {} node(s) to only contain commits before the analysis end at {}.", supplierArray);
        HashSet<CommitGraphNode> visitedNodes = new HashSet<CommitGraphNode>();
        ArrayDeque<CommitGraphNode> queuedNodes = new ArrayDeque<CommitGraphNode>();
        nodesByName.values().stream().filter(CommitGraphNode::isHead).forEach(queuedNodes::add);
        long analysisEndTimestamp = this.analysisEnd.toEpochMilli();
        while (!queuedNodes.isEmpty()) {
            CommitGraphNode node = (CommitGraphNode)queuedNodes.pop();
            boolean isNew = visitedNodes.add(node);
            if (!isNew || node.getCommitTimestamp() <= analysisEndTimestamp) continue;
            queuedNodes.addAll((Collection<CommitGraphNode>)node.getParents());
            GitRepositoryConnection.deleteNode(nodesByName, node);
        }
        LOGGER.trace("Filtered out {} nodes after the analysis end.", new Supplier[]{() -> totalNodesBefore - nodesByName.size()});
    }

    private void synchronizeSubModules(Map<String, CommitGraphNode> nodesByName) throws RepositoryException {
        if (this.gitParameters.isIncludeSubModules()) {
            this.repository.initAndSynchronizeSubModules(nodesByName.keySet(), this.gitParameters.getSubModuleRecursionDepth());
        }
    }

    private void skipExpansionsUntilNextChange() throws StorageException {
        if (this.repository.hasRemoteConfiguration()) {
            this.gitParameters.getGitInfoIndex().setCommitTreeExpansionNeeded(false);
        }
    }

    private void clearGitInfoIndexIfDefaultBranchChanged() throws StorageException {
        LOGGER.traceEntry();
        Optional<String> previousDefaultBranchName = this.gitParameters.getGitInfoIndex().getPreviousDefaultBranchName();
        if (previousDefaultBranchName.isPresent()) {
            if (previousDefaultBranchName.get().equals(this.getDefaultBranchName())) {
                LOGGER.traceExit((Object)"Nothing changed");
                return;
            }
            LOGGER.trace("Clearing git info index");
            this.gitParameters.getGitInfoIndex().clearStore();
        }
        LOGGER.trace("Previous default branch name: {}", (Object)this.getDefaultBranchName());
        this.gitParameters.getGitInfoIndex().setPreviousDefaultBranchName(this.getDefaultBranchName());
        LOGGER.traceExit();
    }

    private boolean shouldSkipCommitTreeExpansion(ICommitTree commitTree) throws StorageException, RepositoryException {
        LOGGER.traceEntry();
        if (this.gitParameters.getGitInfoIndex() == null) {
            return (Boolean)LOGGER.traceExit((Object)false);
        }
        boolean shouldExpandBasedOnTimePassed = this.shouldExpandBasedOnPassedTimeSinceLastExpansion();
        if (shouldExpandBasedOnTimePassed) {
            return (Boolean)LOGGER.traceExit((Object)false);
        }
        if (this.gitParameters.getGitInfoIndex().isDebugDumpRequested()) {
            return (Boolean)LOGGER.traceExit((Object)false);
        }
        if (!commitTree.isForceExpansionPending() && !this.isCommitTreeExpansionNeeded()) {
            return (Boolean)LOGGER.traceExit((Object)true);
        }
        return (Boolean)LOGGER.traceExit((Object)(!commitTree.getAllNodes().isEmpty() && this.areRepositoryRefsStillTheSame() && (Boolean)this.gitParameters.getCrossRepositoryMergeRequestSourceBranchesIndex().computeWithLock(lockedIndexAccess -> this.hasAllCrossRepositoryBranches(commitTree, (CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess)lockedIndexAccess)) != false ? 1 : 0));
    }

    private boolean hasAllCrossRepositoryBranches(ICommitTree commitTree, CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess lockedIndexAccess) throws StorageException {
        HashSet missingCrossRepositoryBranches = CollectionUtils.differenceSet((Collection)CollectionUtils.map(lockedIndexAccess.readAllBranches(), CrossRepositoryMergeRequestSourceBranch::localBranchName), (Collection[])new Collection[]{commitTree.getLiveBranchNames()});
        if (!missingCrossRepositoryBranches.isEmpty()) {
            LOGGER.info("Scheduling commit tree expansion due to missing cross-repository branches {}.", (Object)missingCrossRepositoryBranches);
        }
        return missingCrossRepositoryBranches.isEmpty();
    }

    private boolean areRepositoryRefsStillTheSame() throws RepositoryException {
        try {
            List allRefs = this.repository.getRepository().getRefDatabase().getRefs();
            StreamingXXHash64 refHash = XXHashUtils.streamingHash64();
            for (Ref ref : allRefs) {
                if (this.isExcluded(ref)) continue;
                XXHashUtils.updateHash((StreamingXXHash64)refHash, (String)ref.getName());
                XXHashUtils.updateHash((StreamingXXHash64)refHash, (String)ref.getObjectId().getName());
            }
            byte[] newRefHash = ByteArrayUtils.longToByteArray((long)refHash.getValue());
            byte[] previousRefHash = this.gitParameters.getGitInfoIndex().getRefsHash();
            if (previousRefHash == null || !Arrays.equals(newRefHash, previousRefHash)) {
                this.gitParameters.getGitInfoIndex().setRefsHash(newRefHash);
                return false;
            }
            return true;
        }
        catch (IOException | StorageException e) {
            throw new RepositoryException("Problem comparing previous ref md5 against current ref md5.", e);
        }
    }

    public Map<String, CommitGraphNode> runPathBuildingAlgorithmAndPersistResults(IChangeRetrieverCommitTree commitTree) throws StorageException, RepositoryException {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((IChangeRetrieverCommitTree)commitTree).getCommitTreeDump();
        LOGGER.traceEntry("Expanding commit tree {}.", supplierArray);
        RawCommitGraph rawCommitGraph = (RawCommitGraph)this.gitParameters.getCrossRepositoryMergeRequestSourceBranchesIndex().computeWithLock(lockedIndexAccess -> this.buildCommitGraph(commitTree.getAllNodes(), (CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess)lockedIndexAccess));
        this.onCommitGraphCreated(rawCommitGraph);
        Map<String, CommitGraphNode> nodesByName = rawCommitGraph.nodesByName();
        Map<String, String> branchNamesByCommitName = this.gitParameters.getGitInfoIndex().getBranchNamesByCommitName();
        GitRepositoryConnection.setBranchNameRecommendations(nodesByName, branchNamesByCommitName);
        if (commitTree.isEmpty()) {
            branchNamesByCommitName = new HashMap<String, String>();
            LOGGER.trace("Running path building algorithm for an empty commit tree.");
        } else {
            LOGGER.trace("Running path building algorithm for a non-empty commit tree.");
        }
        HashMap<String, String> oldFixedNodes = new HashMap<String, String>(branchNamesByCommitName);
        this.onPreLabel(commitTree, branchNamesByCommitName, this.gitParameters.getGitInfoIndex().getInitialDefaultBranchRootRevision().orElse(""));
        LOGGER.trace("Branch labeling for {} new commits.", (Object)nodesByName.size());
        this.branchLabeler = this.createBranchLabeler(branchNamesByCommitName, (ICommitTree)commitTree, nodesByName, rawCommitGraph.branchHeadRefs());
        this.branchLabeler.setBranchLabelsForCommits();
        this.processLabeledNodes(nodesByName, (ICommitTree)commitTree);
        GitRepositoryConnection.removeAllHeadCommitsAndParentsWithoutBranchName(nodesByName, branchNamesByCommitName);
        this.handleResurrectedBranches(nodesByName, oldFixedNodes, branchNamesByCommitName);
        GitRepositoryConnection.labelCommitsWithAnonymousBranchNames(nodesByName, branchNamesByCommitName);
        this.gitParameters.getGitInfoIndex().persistBranchNamesByCommitName(branchNamesByCommitName);
        this.onPostLabel(commitTree, branchNamesByCommitName);
        return (Map)LOGGER.traceExit("Found and labeled " + nodesByName.size() + " nodes.", nodesByName);
    }

    private void handleResurrectedBranches(Map<String, CommitGraphNode> nodesByName, Map<String, String> oldFixedNodes, Map<String, String> currentFixedNodes) throws IllegalStateException {
        for (CommitGraphNode node : CommitGraphNode.topSort(nodesByName.values())) {
            CommitGraphNode closestReachableNodeWithSameBranch;
            if (!node.hasBranchNameSet() || !node.isFork() || (closestReachableNodeWithSameBranch = GitRepositoryConnection.getClosestReachableNodeFromSameBranch(node)) == null || node.getParents().contains((Object)closestReachableNodeWithSameBranch)) continue;
            if (this.keepResurrectedBranchHistory.booleanValue()) {
                GitRepositoryConnection.connectResurrectedBranch(node, closestReachableNodeWithSameBranch);
                continue;
            }
            GitRepositoryConnection.eraseOldBranchFromFixedNodes(node.getBranchName(), nodesByName, oldFixedNodes, currentFixedNodes);
        }
    }

    private static void eraseOldBranchFromFixedNodes(String branchToErase, Map<String, CommitGraphNode> nodesByName, Map<String, String> oldFixedNodes, Map<String, String> currentFixedNodes) {
        HashSet nodesWithErasedBranches = new HashSet();
        oldFixedNodes.forEach((commitName, oldFixedBranchName) -> {
            if (GitRepositoryConnection.eraseBranchFromFixedNode(branchToErase, nodesByName, currentFixedNodes, commitName, oldFixedBranchName)) {
                nodesWithErasedBranches.add(commitName);
            }
        });
        if (!nodesWithErasedBranches.isEmpty()) {
            LOGGER.warn("Erased branch name '{}' from {} previously fixed node(s), because the branch was resurrected, i.e., the old branch was deleted and a new one with the same name was created. These nodes will be on a different (likely anonymous) branch from now on, which will cause a rollback. If you prefer a looser alignment with the actual git repository history, set the system property \"{}=true\". In these cases, an artificial merge will be created to connect the commits from the old deleted branch to the new fork. This avoids a rollback, but may result in Teamscale displaying inaccurate change sets for commits on the affected branch.\nReset node(s): {}", (Object)branchToErase, (Object)nodesWithErasedBranches.size(), (Object)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getName(), (Object)String.join((CharSequence)", ", nodesWithErasedBranches));
        }
    }

    private static boolean eraseBranchFromFixedNode(String branchToErase, Map<String, CommitGraphNode> nodesByName, Map<String, String> currentFixedNodes, String commitName, String oldFixedBranchName) {
        if (!branchToErase.equals(oldFixedBranchName)) {
            return false;
        }
        CommitGraphNode node = nodesByName.get(commitName);
        if (node == null) {
            LOGGER.warn("Commit '{}' on branch '{}' is no longer part of the graph, skipping branch erasure.", (Object)commitName, (Object)branchToErase);
            return false;
        }
        if (!branchToErase.equals(node.getBranchName())) {
            LOGGER.info("Did not reset node '{}' on branch '{}' because it was labeled to a different branch than '{}'.", (Object)commitName, (Object)node.getBranchName(), (Object)branchToErase);
            return false;
        }
        currentFixedNodes.remove(commitName);
        node.setBranchName(null);
        return true;
    }

    private static void setBranchNameRecommendations(Map<String, CommitGraphNode> nodesByName, Map<String, String> branchNamesByCommitName) {
        branchNamesByCommitName.forEach((commitName, branchName) -> {
            CommitGraphNode node = (CommitGraphNode)nodesByName.get(commitName);
            if (node != null) {
                node.setBranchName((String)branchName);
            }
        });
    }

    public RawCommitGraph buildCommitGraph(List<? extends ICommitTreeNode> oldNodes, CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess crossRepositoryIndexAccess) throws RepositoryException {
        Pair<Set<RevCommit>, List<BranchHeadRef>> relevantRevCommitsAndHeadRefs = this.collectRelevantRevCommits(oldNodes, crossRepositoryIndexAccess);
        HashMap<String, CommitGraphNode> nodesByName = new HashMap<String, CommitGraphNode>();
        ((Set)relevantRevCommitsAndHeadRefs.getFirst()).forEach(commit -> GitRepositoryConnection.addCommit(nodesByName, commit));
        CollectionUtils.sort(nodesByName.values()).forEach(node -> GitRepositoryConnection.resolveNode(nodesByName, node));
        return new RawCommitGraph(nodesByName, (Collection)relevantRevCommitsAndHeadRefs.getSecond());
    }

    private Pair<Set<RevCommit>, List<BranchHeadRef>> collectRelevantRevCommits(List<? extends ICommitTreeNode> oldNodes, CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess crossRepositoryIndexAccess) throws RepositoryException {
        LOGGER.traceEntry("Collecting RevCommits in analysis scope.", new Supplier[0]);
        Pair<Set<RevCommit>, List<BranchHeadRef>> commitsAndHeadRefs = this.loadRevCommitsAfterAnalysisStart(crossRepositoryIndexAccess);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = ((Set)commitsAndHeadRefs.getFirst())::size;
        LOGGER.debug("Found {} RevCommit(s) in the analysis scope.", supplierArray);
        this.preStartCommitsSupport.addPreStartCommits((Set)commitsAndHeadRefs.getFirst(), this.getRepository(), oldNodes);
        return (Pair)LOGGER.traceExit("All RevCommits relevant for the analysis scope (before branch labeling): {}", commitsAndHeadRefs);
    }

    protected PathBuildingBranchLabeler createBranchLabeler(Map<String, String> branchByCommitFromGitInfoIndex, ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName, Collection<BranchHeadRef> branchHeadRefs) {
        LOGGER.traceEntry();
        Map<String, String> fixedCommitsToBranchName = GitRepositoryConnection.fixScheduledAndProcessedCommits(commitTree, nodesByName);
        LOGGER.trace(fixedCommitsToBranchName);
        if (commitTree instanceof BranchRenamingCommitTreeFacade && !(((BranchRenamingCommitTreeFacade)commitTree).getBranchRenameHandler() instanceof NopBranchRenameHandler)) {
            return new PathBuildingBranchLabeler(branchByCommitFromGitInfoIndex, fixedCommitsToBranchName, nodesByName, branchHeadRefs, this.branchPrioritizer, this::isBranchNameIncludedOrDefaultBranch, ((BranchRenamingCommitTreeFacade)commitTree).getBranchRenameHandler());
        }
        return new PathBuildingBranchLabeler(branchByCommitFromGitInfoIndex, fixedCommitsToBranchName, nodesByName, branchHeadRefs, this.branchPrioritizer, this::isBranchNameIncludedOrDefaultBranch);
    }

    private static Map<String, String> fixScheduledAndProcessedCommits(ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) {
        LOGGER.traceEntry();
        HashMap<String, String> fixedCommitsToBranchName = new HashMap<String, String>();
        for (ICommitTreeNode node : commitTree.getAllNodes()) {
            if (ECommitTreeNodeState.isUnScheduledState((ECommitTreeNodeState)node.getState())) continue;
            GitRepositoryConnection.fixNodeAndParents(node, fixedCommitsToBranchName, commitTree, nodesByName);
        }
        return (Map)LOGGER.traceExit(fixedCommitsToBranchName);
    }

    private static void fixNodeAndParents(ICommitTreeNode startNode, Map<String, String> fixedCommitsToBranchName, ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) {
        Stack<ICommitTreeNode> nodesToFix = new Stack<ICommitTreeNode>();
        nodesToFix.push(startNode);
        while (!nodesToFix.isEmpty()) {
            ICommitTreeNode node = (ICommitTreeNode)nodesToFix.pop();
            if (fixedCommitsToBranchName.containsKey(node.getRevision().getRevision()) || !nodesByName.containsKey(node.getRevision().getRevision())) continue;
            fixedCommitsToBranchName.put(node.getRevision().getRevision(), node.getRevision().getBranchName());
            for (CommitTreeRevision parentRevision : node.getParentRevisions()) {
                nodesToFix.push(commitTree.getNodeByRevision(parentRevision));
            }
        }
    }

    protected void processLabeledNodes(Map<String, CommitGraphNode> nodesByName, ICommitTree commitTree) throws RepositoryException, StorageException {
    }

    protected UnmodifiableSet<RefSpec> getRefSpecs() throws RepositoryException {
        return CollectionUtils.emptySet();
    }

    public List<Ref> getRefsByPrefix(String prefix) throws RepositoryException {
        try {
            return this.getRepository().getRefDatabase().getRefsByPrefix(prefix);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static void addCommit(Map<String, CommitGraphNode> nodesByName, RevCommit commit) {
        GitCommitGraphNode node = new GitCommitGraphNode(commit);
        LOGGER.trace("Adding node to nodesByName: {} -> {}", (Object)commit.getName(), (Object)node);
        nodesByName.put(commit.getName(), node);
    }

    private static void resolveNode(Map<String, CommitGraphNode> nodesByName, CommitGraphNode node) {
        node.resolve(nodesByName);
        LOGGER.trace("Resolved node: {}", (Object)node);
    }

    private Pair<Set<RevCommit>, List<BranchHeadRef>> loadRevCommitsAfterAnalysisStart(CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess crossRepositoryIndexAccess) throws RepositoryException {
        LOGGER.traceEntry("Loading all commits after analysis start {}.", new Object[]{this.analysisStart});
        try (RevWalk revWalk = new RevWalk(this.getRepository());){
            revWalk.setRevFilter(CommitTimeRevFilter.after((Date)Date.from(this.analysisStart)));
            List<BranchHeadRef> headRefs = this.setStartPoints(revWalk, crossRepositoryIndexAccess);
            HashSet commits = new HashSet();
            revWalk.forEach(commits::add);
            Pair pair = (Pair)LOGGER.traceExit((Object)Pair.createPair(commits, headRefs));
            return pair;
        }
    }

    private List<BranchHeadRef> setStartPoints(RevWalk revWalk, CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess crossRepositoryIndexAccess) throws RepositoryException {
        ArrayList<BranchHeadRef> headRefs = new ArrayList<BranchHeadRef>();
        try {
            HashSet<RevCommit> startPoints = new HashSet<RevCommit>();
            for (Ref ref : this.getRepository().getRefDatabase().getRefs()) {
                Optional<RevCommit> commit;
                if (this.isExcluded(ref) || (commit = this.determineCommitFromRef(ref, revWalk)).isEmpty()) continue;
                startPoints.add(commit.get());
                if (!GitRefUtils.isBranchHead((String)ref.getName())) continue;
                headRefs.add(new BranchHeadRef(ref, commit.get()));
            }
            if (startPoints.isEmpty()) {
                throw new RepositoryException("No head references found. A previous clone may have failed. Please clean the working directory: " + String.valueOf(this.repository.getLocalDirectory()));
            }
            this.updateCrossRepositorySourceHeads(revWalk, crossRepositoryIndexAccess, startPoints, headRefs);
            LOGGER.trace("Setting RevWalk start points to [{}].", new Supplier[]{() -> startPoints.stream().map(AnyObjectId::getName).collect(Collectors.joining(", "))});
            revWalk.markStart(startPoints);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return headRefs;
    }

    private void updateCrossRepositorySourceHeads(RevWalk revWalk, CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess crossRepositoryIndexAccess, Set<RevCommit> startPoints, List<BranchHeadRef> headRefs) throws IOException {
        List<CrossRepositoryMergeRequestSourceBranch> crossRepositoryMergeRequestSourceBranches = GitRepositoryConnection.getCrossRepositoryMergeRequestSourceBranches(crossRepositoryIndexAccess);
        for (CrossRepositoryMergeRequestSourceBranch activeCrossRepositoryBranch : crossRepositoryMergeRequestSourceBranches) {
            String rawRef = MERGE_REQUEST_HEAD_REFS_PATTERN.replace("*", Long.toString(activeCrossRepositoryBranch.mergeRequestId()));
            Optional<Ref> reference = Optional.ofNullable(this.repository.getRepository().exactRef(rawRef));
            reference.flatMap(ref -> this.determineCommitFromRef((Ref)ref, revWalk)).ifPresentOrElse(headCommit -> {
                if (startPoints.contains(headCommit)) {
                    LOGGER.warn("The head commit {} found for cross-repository merge request '{}' is already listed as start point.", headCommit, (Object)activeCrossRepositoryBranch.mergeRequestId());
                } else {
                    startPoints.add((RevCommit)headCommit);
                    headRefs.add(new BranchHeadRef(activeCrossRepositoryBranch.localBranchName(), (RevCommit)headCommit));
                }
            }, () -> LOGGER.error("No head commit found for cross-repository merge request '{}'.", (Object)activeCrossRepositoryBranch.mergeRequestId()));
        }
    }

    private static List<CrossRepositoryMergeRequestSourceBranch> getCrossRepositoryMergeRequestSourceBranches(CrossRepositoryMergeRequestSourceBranchesIndex.LockedIndexAccess crossRepositoryIndexAccess) {
        ArrayList<CrossRepositoryMergeRequestSourceBranch> crossRepositoryMergeRequestSourceBranches = new ArrayList<CrossRepositoryMergeRequestSourceBranch>();
        try {
            crossRepositoryMergeRequestSourceBranches = crossRepositoryIndexAccess.readAllBranches();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to load cross-repository merge request heads. Those branches will not be updated.", (Throwable)e);
        }
        return crossRepositoryMergeRequestSourceBranches;
    }

    private Optional<RevCommit> determineCommitFromRef(Ref ref, RevWalk revWalk) {
        try {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().getRefDatabase().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            return Optional.of(revWalk.parseCommit((AnyObjectId)objectId));
        }
        catch (IOException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to peel ref '{}'.", (Object)ref);
            return Optional.empty();
        }
    }

    protected boolean isExcluded(Ref ref) {
        if (GitRefUtils.isHeadRef((String)ref.getName())) {
            return false;
        }
        Optional branchNameFromRef = GitRefUtils.getBranchNameFromRef((String)ref.getName());
        if (branchNameFromRef.isEmpty()) {
            return true;
        }
        String branchName = (String)branchNameFromRef.get();
        if (this.getDefaultBranchName().equals(branchName)) {
            return false;
        }
        return !this.isBranchingEnabled() || !this.getBranchPatternSupport().isIncluded(branchName);
    }

    private static void removeAllHeadCommitsAndParentsWithoutBranchName(Map<String, CommitGraphNode> nodesByName, Map<String, String> branchNamesByCommitName) {
        List<CommitGraphNode> headNodes = nodesByName.values().stream().filter(CommitGraphNode::isHead).toList();
        ArrayDeque<CommitGraphNode> nodesToProcess = new ArrayDeque<CommitGraphNode>(headNodes);
        HashSet<CommitGraphNode> processedNodes = new HashSet<CommitGraphNode>();
        while (!nodesToProcess.isEmpty()) {
            CommitGraphNode node = nodesToProcess.pop();
            boolean isNewNode = processedNodes.add(node);
            if (!isNewNode || node.hasBranchNameSet()) continue;
            nodesToProcess.addAll((Collection<CommitGraphNode>)node.getParents());
            branchNamesByCommitName.remove(node.getName());
        }
    }

    @Override
    protected void updateLiveBranches(IChangeRetrieverCommitTree commitTree) throws RepositoryException {
        commitTree.setLiveBranchNames((Collection)CollectionUtils.filter(this.branchLabeler.extractBranchesWithHeadCommit().values(), this::isBranchNameIncludedOrDefaultBranch));
    }

    private static void labelCommitsWithAnonymousBranchNames(Map<String, CommitGraphNode> nodesByName, Map<String, String> branchNamesByCommitName) {
        List nodesWithoutBranch = CollectionUtils.filter(nodesByName.values(), Predicate.not(CommitGraphNode::hasBranchNameSet));
        nodesWithoutBranch.sort(Comparator.comparingLong(CommitGraphNode::getCommitTimestamp).thenComparing(CommitGraphNode::getName));
        for (CommitGraphNode node : nodesWithoutBranch) {
            String branchName = GitRefUtils.createAnonymousBranchName((String)node.getName());
            for (CommitGraphNode nextNodeToLabel = node; nextNodeToLabel != null && nextNodeToLabel.getBranchName() == null; nextNodeToLabel = nextNodeToLabel.getFirstParent()) {
                nextNodeToLabel.setBranchName(branchName);
                branchNamesByCommitName.put(nextNodeToLabel.getName(), branchName);
                GitRepositoryConnection.logAnonymousHeadNode(nextNodeToLabel);
            }
        }
    }

    private static void logAnonymousHeadNode(CommitGraphNode nextNodeToLabel) {
        try {
            if (nextNodeToLabel.getSuccessors().isEmpty() && GitRefUtils.isAnonymousBranchName((String)nextNodeToLabel.getBranchName())) {
                LOGGER.atError().log("Head node '{}' was labeled to anonymous branch '{}'. This is unexpected, as we only walk over head nodes if they had a head ref pointing to them. Hence, they should always get the name of their head ref over any anonymous name.", (Object)nextNodeToLabel.getName(), (Object)nextNodeToLabel.getBranchName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to log anonymous head and request debug dump.", (Throwable)e);
        }
    }

    private static void deleteNode(Map<String, CommitGraphNode> nodesByName, CommitGraphNode node) {
        node.remove();
        nodesByName.remove(node.getName());
    }

    private Set<String> getExistingCommitsOrRaiseRollbackException(ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) throws RepositoryNeedsRollbackException, StorageException {
        HashMap<String, Long> rollbackTo = new HashMap<String, Long>();
        HashMap<String, String> warningsByBranch = new HashMap<String, String>();
        HashSet<String> existingCommits = new HashSet<String>();
        HashSet<String> noLongerExistingCommits = new HashSet<String>();
        for (ICommitTreeNode commitNode : commitTree.getAllNodes()) {
            String commitName = commitNode.getRevision().getRevision();
            existingCommits.add(commitName);
            CommitNodeConsistencyCheck consistencyCheckResult = this.isConsistent(commitNode, nodesByName.get(commitName));
            if (consistencyCheckResult.isConsistent || !commitNode.getAdjustedTimestamp().isPresent()) continue;
            String branchName = commitNode.getRevision().getBranchName();
            rollbackTo.merge(branchName, commitNode.getAdjustedTimestamp().getAsLong() - 1L, Math::min);
            if ((Long)rollbackTo.get(branchName) == commitNode.getAdjustedTimestamp().getAsLong() - 1L) {
                warningsByBranch.put(branchName, consistencyCheckResult.warning);
            }
            if (consistencyCheckResult.existsInGitRepo) continue;
            noLongerExistingCommits.add(commitName);
        }
        if (!noLongerExistingCommits.isEmpty()) {
            this.gitParameters.getRepositoryRevisionIndex().removeRevisions(noLongerExistingCommits);
        }
        if (!rollbackTo.isEmpty()) {
            this.raiseRollbackException(rollbackTo, warningsByBranch);
        }
        return existingCommits;
    }

    private void raiseRollbackException(Map<String, Long> rollbackTo, Map<String, String> warningsByBranch) throws StorageException, RepositoryNeedsRollbackException {
        StringBuilder builder = new StringBuilder("Performing rollback to compensate for changed git structure. Reasons:");
        for (String warning : warningsByBranch.values()) {
            builder.append("\n").append(warning);
        }
        String rollbackReason = builder.toString();
        if (!this.gitParameters.getPostponedRollbackIndex().hasEntryWithSameReason(rollbackReason)) {
            LOGGER.warn(rollbackReason);
        }
        RepositoryNeedsRollbackException repositoryNeedsRollbackException = new RepositoryNeedsRollbackException(rollbackReason, rollbackTo);
        this.onRepositoryNeedsRollbackException(repositoryNeedsRollbackException);
        throw repositoryNeedsRollbackException;
    }

    private CommitNodeConsistencyCheck isConsistent(ICommitTreeNode commitNode, CommitGraphNode gitNode) {
        if (gitNode == null) {
            return new CommitNodeConsistencyCheck(false, false, "Encountered commit that is not present in the git repository any more: " + String.valueOf(commitNode) + ". This was likely removed by a rebase or force push operation.");
        }
        String commitTreeBranchName = commitNode.getRevision().getBranchName();
        if (!commitTreeBranchName.equals(gitNode.getBranchName())) {
            if (this.branchLabeler.getSuggestions().hasHigherImportance(gitNode.getBranchName(), commitTreeBranchName)) {
                return new CommitNodeConsistencyCheck(false, true, "Overwritten branch " + commitTreeBranchName + " with " + gitNode.getBranchName() + " likely caused by a fast-forward merge.");
            }
            return new CommitNodeConsistencyCheck(false, true, "Branch name inconsistent between commit tree and git:\n\tCommit Tree: " + String.valueOf(commitNode.getRevision()) + "\n\tGit:         " + gitNode.getName() + "@" + gitNode.getBranchName());
        }
        Set commitParents = CollectionUtils.mapToSet((Collection)commitNode.getParentRevisions(), CommitTreeRevision::getRevision);
        List gitParents = CollectionUtils.map(gitNode.getParents(), CommitGraphNode::getName);
        boolean parentListsEqual = commitParents.containsAll(gitParents);
        Object warning = "";
        if (!parentListsEqual) {
            warning = "Parent commits in commit tree do not match parents in git.\n\tCommit Tree: " + String.valueOf(commitNode) + "\n\tGit:         " + String.valueOf(gitParents);
        }
        return new CommitNodeConsistencyCheck(parentListsEqual, true, (String)warning);
    }

    private Set<ICommitTreeNode> insertNewNodesIntoCommitTree(IChangeRetrieverCommitTree commitTree, Map<String, CommitGraphNode> nodesByName, Set<String> existingCommits) throws StorageException {
        HashSet<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();
        for (CommitGraphNode node : CommitGraphNode.topSort(nodesByName.values())) {
            if (existingCommits.contains(node.getName())) continue;
            List parentRevisions = CollectionUtils.map(node.getParents(), parent -> new CommitTreeRevision(parent.getName(), parent.getBranchName()));
            addedNodes.add(commitTree.addNode(new CommitTreeRevision(node.getName(), node.getBranchName()), node.getCommitTimestamp(), parentRevisions, arg_0 -> ((Logger)LOGGER).warn(arg_0)));
        }
        this.onPostInsertCommitTreeNodes(commitTree);
        return CollectionUtils.asUnmodifiable(addedNodes);
    }

    private static void connectResurrectedBranch(CommitGraphNode currentNode, CommitGraphNode reachableNode) {
        LOGGER.warn("While processing commit {}, a virtual parent reference to commit {} was created, since they belong to the same branch ({}) but do not yet share an ancestor relation.\nThis will affect the change set and findings of this commit, but in cases of resurrected branches, it is necessary in order to keep the history of the previously deleted branch around and to avoid rollbacks.\nIf you prefer a stricter alignment with the actual git repository history, set the system property \"{}=false\". In these cases, a rollback will then occur which will remove the old branch reference.", (Object)currentNode.getName(), (Object)reachableNode.getName(), (Object)currentNode.getBranchName(), (Object)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getName());
        currentNode.addAsFirstParent(reachableNode);
    }

    private static @Nullable CommitGraphNode getClosestReachableNodeFromSameBranch(CommitGraphNode node) {
        ArrayDeque<CommitGraphNode> queue = new ArrayDeque<CommitGraphNode>((Collection<CommitGraphNode>)node.getParents());
        HashSet<CommitGraphNode> queuedNodes = new HashSet<CommitGraphNode>();
        while (!queue.isEmpty()) {
            CommitGraphNode reachableNode = (CommitGraphNode)queue.poll();
            if (Objects.equals(reachableNode.getBranchName(), node.getBranchName())) {
                return reachableNode;
            }
            for (CommitGraphNode parent : reachableNode.getParents()) {
                if (!queuedNodes.add(parent)) continue;
                queue.add(parent);
            }
        }
        return null;
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        RevCommit commit = this.repository.getCommit(revision.getRevision());
        long commitTimestamp = new GitCommitGraphNode(commit).getCommitTimestamp();
        RepositoryChangeSet changes = new RepositoryChangeSet(revision.getRevision(), new CommitDescriptor(revision.getBranchName(), commitTimestamp), commit.getAuthorIdent().getName(), commit.getFullMessage(), this.getCodePatternSupport(), this.analysisStart.toEpochMilli());
        this.repository.createChangeEntries(commit, this.repository.getCommit(parentRevision.getRevision()), changes, parentRevision.getBranchName(), "", this.gitParameters.getSubModuleRecursionDepth());
        return changes;
    }

    @Override
    public boolean supportsSkipping() {
        return true;
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        return this.crawl(this.repository.getCommit(revision.getRevision()));
    }

    private void synchronizeIfNecessary(@Nullable String revision) throws RepositoryException {
        if (revision == null || revision.equals(this.lastSynchronizedRevision)) {
            return;
        }
        if (this.repository.getOptionalCommit(revision).isEmpty()) {
            this.doSynchronize();
        }
        this.lastSynchronizedRevision = revision;
    }

    public void doSynchronize() throws RepositoryException {
        try {
            this.performSynchronization(false);
        }
        catch (RescheduleRequestedException rescheduleRequestedException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    protected void doSynchronizeAndRescheduleIfNecessary() throws RescheduleRequestedException {
        this.performSynchronization(true);
    }

    private void performSynchronization(boolean shouldReschedule) throws RescheduleRequestedException {
        LOGGER.traceEntry("Synchronizing repository '{}'.", new Object[]{this.getRepository().getDirectory()});
        this.onPreSynchronize();
        try {
            this.synchronizeUsingRefSpecs();
            this.onSynchronizeSuccessful();
        }
        catch (RepositoryException e) {
            if (shouldReschedule && e.getMessage().contains("429 Too Many Requests")) {
                LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to synchronize repository '{}' due to rate limiting. Rescheduling again.", (Object)this.getRepository().getDirectory());
                throw new RescheduleRequestedException((Throwable)e, Instant.now());
            }
            LOGGER.atError().withMarker(LoggingUtils.DOWN_CONNECTOR_STATUS).withThrowable((Throwable)e).log("Failed to synchronize repository '{}'. Continuing with local changes.", (Object)this.getRepository().getDirectory());
        }
        this.onPostSynchronize();
        LOGGER.traceExit("Finished synchronization of repository '{}'.", (Object)this.getRepository().getDirectory());
    }

    @VisibleForTesting
    protected void synchronizeUsingRefSpecs() throws RepositoryException {
        LOGGER.trace("Synchronizing repository '{}' with ref specs.", (Object)this.getRepository());
        this.repository.synchronize(CollectionUtils.unionSet(this.getRefSpecs(), (Collection[])new Collection[]{this.getUserRequestedRefSpecs(), GitRepositoryConnection.getCrossRepoSourceBranchRefs(Objects.requireNonNull(this.gitParameters.getConnectorType(), "The git connector type must always be set"))}));
    }

    private Collection<RefSpec> getUserRequestedRefSpecs() {
        return CollectionUtils.map(this.gitParameters.getUserRequestedRefSpecs(), RefSpec::new);
    }

    @VisibleForTesting
    static Collection<RefSpec> getCrossRepoSourceBranchRefs(@NonNull ERepositoryConnector connectorType) {
        Object relevantPatterns = switch (connectorType) {
            case ERepositoryConnector.GITHUB -> Set.of("refs/pull/*/head");
            case ERepositoryConnector.GITLAB -> Set.of("refs/merge-requests/*/head");
            case ERepositoryConnector.BITBUCKET_SERVER -> Set.of("refs/pull-requests/*/from");
            default -> CollectionUtils.emptySet();
        };
        return relevantPatterns.stream().map(sourceRefPattern -> "+%s:%s".formatted(sourceRefPattern, MERGE_REQUEST_HEAD_REFS_PATTERN)).map(RefSpec::new).toList();
    }

    protected void onSynchronizeSuccessful() throws RepositoryException {
    }

    private Set<String> crawl(RevCommit commit) throws RepositoryException {
        return this.repository.crawl(commit, this.gitParameters.getSubModuleRecursionDepth());
    }

    @Override
    public byte[] getContent(String path, CommitTreeRevision revision) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        return this.repository.getContent(path, revision.getRevision(), this.gitParameters.getSubModuleRecursionDepth()).orElse(null);
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        RevCommit commit = this.repository.getCommit(revision.getRevision());
        return new Pair((Object)commit.getAuthorIdent().getName(), (Object)commit.getFullMessage());
    }

    @Override
    public String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        RevCommit commit = this.repository.getCommit(revision.getRevision());
        return commit.getAuthorIdent().getEmailAddress();
    }

    private boolean shouldExpandBasedOnPassedTimeSinceLastExpansion() throws StorageException {
        return this.gitParameters.getGitInfoIndex().getLastCommitTreeExpansion().map(instant -> instant.isBefore(Instant.now().minus(MAXIMUM_TIME_BETWEEN_COMMIT_TREE_EXPANSIONS))).orElse(true);
    }

    private void storeLastExpansionTimestamp() throws StorageException {
        this.gitParameters.getGitInfoIndex().setLastCommitTreeExpansion(Instant.now());
    }

    @Override
    public void close() {
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public boolean isGerritConnection() {
        return false;
    }

    public boolean isAbapConnection() {
        return false;
    }

    protected void updateBranchPointerIndexFromGitRepository(Map<String, CommitGraphNode> nodesByName) throws RepositoryException {
        HashMap<String, String> branchToShaMap = new HashMap<String, String>();
        GitBranchPointerIndex gitBranchPointerIndex = this.gitParameters.openBranchPointerIndex();
        try (Git git = new Git(this.getRepository());
             RevWalk revWalk = new RevWalk(this.getMainRepository().getRepository());){
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            for (Ref ref : refs) {
                Optional<RevCommit> commit;
                String branchName = ref.getName();
                if (branchName.startsWith("refs/remotes/origin/") || !branchName.startsWith("refs/heads/") || (branchName = StringUtils.stripPrefix((String)branchName, (String)"refs/heads/")).equals("HEAD") || !(commit = this.determineCommitFromRef(ref, revWalk)).isPresent() || !nodesByName.containsKey(commit.get().getName())) continue;
                branchToShaMap.put(branchName, commit.get().getName());
            }
            gitBranchPointerIndex.storeBranchPointerLookup(branchToShaMap);
        }
        catch (StorageException | GitAPIException e) {
            throw new RepositoryException(e);
        }
    }

    public Long getGerritMinimalCreationTimestamp() {
        return null;
    }

    public void storeFailedFetch(String missingRef) throws StorageException {
        this.gitParameters.getGitInfoIndex().storeFailedFetch(missingRef);
    }

    public List<RefSpec> filterIgnoredRefSpecs(Collection<RefSpec> refSpecs) {
        return refSpecs.stream().filter(this::isBelowFailedFetchThreshold).toList();
    }

    private boolean isBelowFailedFetchThreshold(RefSpec refSpec) {
        try {
            return (long)this.gitParameters.getGitInfoIndex().getFailedFetchCount(refSpec.getSource()) <= GitRepositoryConnection.readFailedFetchThreshold();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read failed fetch count for ref spec '{}'. Will attempt to fetch ref.", (Object)refSpec, (Object)e);
            return true;
        }
    }

    @VisibleForTesting
    static long readFailedFetchThreshold() {
        return SystemPropertyUtils.getSystemPropertyAsLong(FAILED_FETCH_LIMIT_PROPERTY_NAME, 5L);
    }

    public void requestGarbageCollection() throws StorageException {
        this.gitParameters.getPendingGarbageCollectionIndex().requestGC(this.getRepository().getDirectory().toString());
    }

    private void onPreSynchronize() {
        this.repoDumper.recordRepositoryState(EGitRepositoryDumpState.PRE_SYNCHRONIZE, this.repository);
    }

    private void onPostSynchronize() {
        this.repoDumper.recordRepositoryState(EGitRepositoryDumpState.POST_SYNCHRONIZE, this.repository);
        this.fillBranchPointerHistoryIndex();
    }

    private void fillBranchPointerHistoryIndex() {
        if (!EFeatureToggle.ENABLE_BRANCH_POINTER_HISTORY_RECORDING.isEnabled()) {
            return;
        }
        try {
            BranchPointerHistoryIndex branchPointerHistoryIndex = this.baseParameters.getBranchPointerHistoryIndex();
            Instant now = DateTimeUtils.now();
            HashSet<String> inactiveBranches = new HashSet<String>(branchPointerHistoryIndex.getActiveBranches());
            for (Ref branchRef : this.repository.getAllBranches(false)) {
                String branchName = GitUtils.getBranchNameFromRef(branchRef).orElseThrow(() -> new IllegalStateException("Expected %s to be a branch head reference".formatted(branchRef)));
                String revision = branchRef.getLeaf().getObjectId().getName();
                branchPointerHistoryIndex.recordBranchRevision(branchName, revision, now);
                inactiveBranches.remove(branchName);
            }
            for (String inactiveBranch : inactiveBranches) {
                branchPointerHistoryIndex.recordBranchDeletion(inactiveBranch, now);
            }
        }
        catch (RuntimeException | RepositoryException | StorageException e) {
            LOGGER.warn("Failed to fill BranchPointerHistoryIndex", e);
        }
    }

    private void onPreLabel(IChangeRetrieverCommitTree commitTree, Map<String, String> branchNamesByCommitName, String initialDefaultBranchRootRevision) {
        this.repoDumper.recordCommitTree(EGitRepositoryDumpState.PRE_LABEL, commitTree);
        this.repoDumper.recordBranchNamesByCommitName(EGitRepositoryDumpState.PRE_LABEL, branchNamesByCommitName);
        this.repoDumper.recordInitialDefaultBranchRootRevision(EGitRepositoryDumpState.PRE_LABEL, initialDefaultBranchRootRevision);
    }

    private void onCommitGraphCreated(RawCommitGraph commitGraph) {
        this.repoDumper.recordBranchHeadRefs(EGitRepositoryDumpState.PRE_LABEL, commitGraph.branchHeadRefs());
        this.repoDumper.recordCommitGraph(EGitRepositoryDumpState.PRE_LABEL, commitGraph.nodesByName());
    }

    private void onPostLabel(IChangeRetrieverCommitTree commitTree, Map<String, String> branchNamesByCommitName) {
        this.repoDumper.recordCommitTree(EGitRepositoryDumpState.POST_LABEL, commitTree);
        this.repoDumper.recordBranchNamesByCommitName(EGitRepositoryDumpState.POST_LABEL, branchNamesByCommitName);
    }

    private void onPreFilterGitTree(Map<String, CommitGraphNode> nodesByName) {
        this.repoDumper.recordCommitGraph(EGitRepositoryDumpState.PRE_FILTER_GIT_TREE, nodesByName);
    }

    private void onPostFilterGitTree(Map<String, CommitGraphNode> nodesByName) {
        this.repoDumper.recordCommitGraph(EGitRepositoryDumpState.POST_FILTER_GIT_TREE, nodesByName);
    }

    private void onPostInsertCommitTreeNodes(IChangeRetrieverCommitTree commitTree) {
        this.repoDumper.recordCommitTree(EGitRepositoryDumpState.POST_INSERT_COMMIT_TREE_NODES, commitTree);
    }

    private void onRepositoryNeedsRollbackException(RepositoryNeedsRollbackException rollbackException) {
        this.repoDumper.recordRollbackException(rollbackException);
        this.repoDumper.performDump();
    }

    public record RawCommitGraph(Map<String, CommitGraphNode> nodesByName, Collection<BranchHeadRef> branchHeadRefs) {
    }

    private record CommitNodeConsistencyCheck(boolean isConsistent, boolean existsInGitRepo, String warning) {
    }
}

