/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket;

import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.TestGapVotingInfo;
import java.util.Set;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class BitbucketUtils {
    private static final String TEAMSCALE_FINDINGS_BUILD_KEY = "teamscale-findings-build";
    public static final String TEAMSCALE_TEST_GAPS_BUILD_KEY = "teamscale-test-gaps-build";
    public static final String TEAMSCALE_TEST_COVERAGE_BUILD_KEY = "teamscale-test-coverage-build";
    public static final Set<String> TEAMSCALE_BUILD_KEYS = Set.of("teamscale-findings-build", "teamscale-test-gaps-build", "teamscale-test-coverage-build");

    public static CommitStatus createFindingsCommitStatus(FindingsVotingInfo findingsVotingInfo, String targetUrl) {
        return BitbucketUtils.createCommitStatus(TEAMSCALE_FINDINGS_BUILD_KEY, "Teamscale Findings", targetUrl, findingsVotingInfo);
    }

    public static CommitStatus createTestGapCommitStatus(TestGapVotingInfo testGapVotingInfo, String targetUrl) {
        return BitbucketUtils.createCommitStatus(TEAMSCALE_TEST_GAPS_BUILD_KEY, "Teamscale Test Gaps", targetUrl, testGapVotingInfo);
    }

    public static CommitStatus createTestCoverageCommitStatus(LineCoverageVotingInfo lineCoverageVotingInfo, String targetUrl) {
        return BitbucketUtils.createCommitStatus(TEAMSCALE_TEST_COVERAGE_BUILD_KEY, "Teamscale Test Coverage", targetUrl, lineCoverageVotingInfo);
    }

    private static CommitStatus createCommitStatus(String key, String name, String targetUrl, IVotingInfo votingInfo) {
        CommitStatus status = new CommitStatus(key, name);
        status.setUrl(targetUrl);
        status.setDescription(votingInfo.toReadableDescription());
        String state = votingInfo.isPositiveVote() ? "SUCCESSFUL" : "FAILED";
        status.setState(state);
        return status;
    }

    private BitbucketUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

