/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.in_progress_reporting;

import com.google.common.base.Preconditions;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.repository.git.GitRevisionResolver;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.VotingRequirementsChecker;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class AnalysisInProgressReporter {
    private final IndexLayer indexLayer;
    private final ConnectorConfiguration connectorConfiguration;
    private final GitRepositoryManagementConnectorDescriptorBase connectorDescriptor;
    private final ProjectStorageSystem projectStorage;
    private final GlobalStorageSystem globalStorage;
    private final Logger logger;
    private final PublicProjectId publicProjectId;

    @TestOnly
    protected AnalysisInProgressReporter(IndexLayer indexLayer, ConnectorConfiguration connectorConfiguration, GitRepositoryManagementConnectorDescriptorBase connectorDescriptor, ProjectStorageSystem projectStorage, Logger logger, PublicProjectId publicProjectId) throws StorageException {
        this.indexLayer = indexLayer;
        this.globalStorage = indexLayer.openGlobalStorageSystem();
        this.connectorConfiguration = connectorConfiguration;
        this.connectorDescriptor = connectorDescriptor;
        this.projectStorage = projectStorage;
        this.logger = logger;
        this.publicProjectId = publicProjectId;
    }

    protected AnalysisInProgressReporter(PlatformRepositoryIdentifier repositoryIdentifier, IndexLayer indexLayer, Class<? extends GitRepositoryManagementConnectorDescriptorBase> descriptorType, Logger logger) throws StorageException, ProjectConfigurationException {
        this.indexLayer = indexLayer;
        this.globalStorage = indexLayer.openGlobalStorageSystem();
        this.logger = logger;
        ProjectIndex projectIndex = (ProjectIndex)this.globalStorage.openGlobalIndex(ProjectIndex.class);
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            Optional<ConnectorConfiguration> guessedConnector = MergeRequestUtils.guessConnectorFromProject(indexLayer, (IProjectId)projectInfo.getInternalId(), repositoryIdentifier.asRepositoryName(), List.of(configuration -> ConnectorUtils.tryCreateConnectorDescriptor((ConnectorConfiguration)configuration).filter(descriptor -> descriptor.getClass().equals(descriptorType)).isPresent()));
            if (!guessedConnector.isPresent()) continue;
            this.connectorConfiguration = guessedConnector.get();
            this.connectorDescriptor = this.loadConnectorDescriptor(this.connectorConfiguration, indexLayer, projectInfo.getInternalId(), descriptorType);
            this.projectStorage = indexLayer.openProjectStorageSystem((IProjectId)this.connectorDescriptor.getProjectId());
            this.publicProjectId = projectInfo.getPrimaryPublicId();
            return;
        }
        throw new ConnectorNotAvailableException("Failed to find connector matching repository identifier '%s'.".formatted(repositoryIdentifier.asRepositoryName()));
    }

    private <T extends GitRepositoryManagementConnectorDescriptorBase> T loadConnectorDescriptor(ConnectorConfiguration connectorConfiguration, IndexLayer indexLayer, InternalProjectId projectId, Class<T> descriptorType) throws ProjectConfigurationException, StorageException {
        ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)new ConfigurationInitializationContext(indexLayer, (IExternalCredentialsProvider)this.globalStorage.openGlobalIndex(ExternalCredentialsIndex.class)), (InternalProjectId)projectId);
        Preconditions.checkArgument((boolean)connectorDescriptor.getClass().equals(descriptorType), (String)"Expected descriptor to be of type '%s' but was '%s'.", (Object)descriptorType.getName(), (Object)connectorDescriptor.getClass().getName());
        return (T)((Object)((GitRepositoryManagementConnectorDescriptorBase)((Object)descriptorType.cast(connectorDescriptor))));
    }

    public void reportAnalysisInProgress(String headRevision, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException, ServiceCallException, ProjectConfigurationException {
        if (AnalysisInProgressReporter.isInProgressNotificationDisabled() && !this.needsCleanUp()) {
            return;
        }
        CommitDescriptor commit = this.resolveCommitDescriptor(headRevision, this.getExternalCredentials());
        if (this.needsCleanUp()) {
            this.performCleanUp(commit);
        }
        if (AnalysisInProgressReporter.isInProgressNotificationDisabled()) {
            return;
        }
        try {
            this.checkVotingRequirements(mergeRequestIdentifier, commit);
        }
        catch (VotingException.Skipped skipCause) {
            this.logger.debug("Posting \"In Progress\" check run for commit '{}' was skipped", (Object)commit, (Object)skipCause);
            return;
        }
        this.postAnalysisInProgressReport(headRevision, commit, mergeRequestIdentifier);
    }

    @VisibleForTesting
    public void checkVotingRequirements(MergeRequestIdentifier mergeRequestIdentifier, CommitDescriptor commit) throws VotingException.Skipped, StorageException {
        this.initVotingRequirementsChecker().checkVotingRequirements(false, commit, mergeRequestIdentifier, this.connectorConfiguration, null, null, null);
    }

    private static boolean isInProgressNotificationDisabled() {
        return !EFeatureToggle.ENABLE_MERGE_REQUEST_ANALYSIS_IN_PROGRESS_NOTIFICATION.isEnabled();
    }

    protected boolean needsCleanUp() {
        return false;
    }

    protected void performCleanUp(CommitDescriptor commit) throws StorageException, ServiceCallException {
    }

    @VisibleForTesting
    protected VotingRequirementsChecker initVotingRequirementsChecker() {
        return new VotingRequirementsChecker(this.publicProjectId, this.globalStorage, this.projectStorage);
    }

    protected abstract void postAnalysisInProgressReport(String var1, CommitDescriptor var2, MergeRequestIdentifier var3) throws StorageException, ServiceCallException;

    protected abstract ExternalCredentials getExternalCredentials() throws StorageException, ServiceCallException, ConnectorValidationException;

    protected TeamscaleProjectLinkProvider getLinkProvider() throws StorageException {
        return new TeamscaleProjectLinkProvider(BaseUrlOption.getBaseUrl((GlobalStorageSystem)this.globalStorage), this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)this.connectorDescriptor.getProjectId()));
    }

    @VisibleForTesting
    public CommitDescriptor resolveCommitDescriptor(String headRevision, ExternalCredentials externalCredentials) throws StorageException {
        return new GitRevisionResolver(this.connectorDescriptor, this.connectorDescriptor.getRepositoryName(), this.connectorDescriptor.getProjectId(), externalCredentials, this.indexLayer).resolveToCommitDescriptor(headRevision).orElseThrow(() -> new StorageException("Failed to resolve commit for revision '" + headRevision + "'."));
    }

    protected GlobalStorageSystem getGlobalStorage() {
        return this.globalStorage;
    }

    protected ProjectStorageSystem getProjectStorage() {
        return this.projectStorage;
    }

    protected GitRepositoryManagementConnectorDescriptorBase getConnectorDescriptor() {
        return this.connectorDescriptor;
    }

    protected ConnectorConfiguration getConnectorConfiguration() {
        return this.connectorConfiguration;
    }

    public static class ConnectorNotAvailableException
    extends ProjectConfigurationException {
        private static final long serialVersionUID = 1L;

        private ConnectorNotAvailableException(String message) {
            super(message);
        }
    }
}

