/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import java.net.URI;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;

public class AbapGitRepositoryConnection
extends GitRepositoryConnection {
    public AbapGitRepositoryConnection(RepositoryConnectorBaseParameterStep baseParameters, GitRepositoryConnectorParameterStep gitParameters, URI repositoryUri, String userName, String password, GitPrivateKeyOption privateKeyOption, ICancelable cancelable) throws RepositoryException {
        super(baseParameters, gitParameters, new GitCredentials(userName, password, repositoryUri, privateKeyOption), cancelable);
    }

    @Override
    public boolean isIncluded(String path) {
        return super.isIncluded(path) && !AbapGitRepositoryConnection.isDdicFileFromSAP(path);
    }

    @Override
    public boolean isAbapConnection() {
        return true;
    }

    static boolean isDdicFileFromSAP(String filePath) {
        if (!filePath.endsWith(".abap_ddic")) {
            return false;
        }
        char firstChar = Character.toUpperCase(filePath.charAt(0));
        return Character.isLetter(firstChar) && firstChar != 'Y' && firstChar != 'Z';
    }
}

