/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.google.common.base.Preconditions;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.RepositoryException;

public class TfsBranchRetriever
implements IBranchRetriever {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0);
        TfsHttpConnection tfsHttpConnection = new TfsHttpConnection(credentials, HttpRequestRetryPolicy.SYSTEM_DEFAULT, LOGGER);
        String basePath = connectorConfiguration.getOptionValue("Path suffix");
        if (basePath == null) {
            basePath = "";
        }
        List<String> branchLookupPathsList = TfsRepositoryUtils.getBranchLookupPaths(connectorConfiguration);
        return TfsRepositoryUtils.listBranchesForPaths(tfsHttpConnection.createAzureDevOpsTfvcRestClient(), basePath, branchLookupPathsList, new IncludeExcludeRegexSupport(), true);
    }
}

