/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ProcessArtifactIndexes;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.resource.utils.EResourceType;
import com.teamscale.index.tests.TestExecutionIndexes;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ResourceServiceUtils {
    public static Optional<String> resolveUniqueArchitectureElementPath(String uniformPath, MetricsToArchitectureMetricsMappingIndex metricsToArchitectureMetricsMappingIndex) throws StorageException {
        if (!ArchitectureMetricsUtils.isArchitectureArtifactPath(uniformPath)) {
            return Optional.of(uniformPath);
        }
        if (uniformPath.endsWith("/") || UniformPathUtils.isArchitectureRootComponent((String)uniformPath)) {
            return Optional.empty();
        }
        Set<String> leafPaths = ArchitectureMetricsUtils.getLeafPaths(metricsToArchitectureMetricsMappingIndex, uniformPath);
        if (leafPaths.size() != 1) {
            return Optional.empty();
        }
        String resolvedPath = (String)CollectionUtils.getAny(leafPaths);
        if (!UniformPathUtils.getElementName((String)uniformPath).equals(UniformPathUtils.getElementName((String)resolvedPath))) {
            return Optional.empty();
        }
        return Optional.ofNullable(resolvedPath);
    }

    public static TokenElementIndex openContentIndex(String uniformPathString, HistoryAccessOption historyAccessOption, ProjectStorageSystem projectStorageSystem) throws StorageException {
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)uniformPathString);
        return ResourceServiceUtils.openContentIndex(uniformPath, historyAccessOption, projectStorageSystem);
    }

    public static TokenElementIndex openContentIndex(UniformPath uniformPath, HistoryAccessOption historyAccessOption, ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (uniformPath.isNonCodePath()) {
            return (TokenElementIndex)projectStorageSystem.openProjectIndex(ProcessArtifactIndexes.PROCESS_ARTIFACT_INDEX_TYPE, "process-artifacts", historyAccessOption);
        }
        if (uniformPath.isTestImplementationPath() || uniformPath.isTestExecutionPath()) {
            return (TokenElementIndex)projectStorageSystem.openProjectIndex(TestExecutionIndexes.TEST_EXECUTION_CONTENT_INDEX_TYPE, "test-executions-content", historyAccessOption);
        }
        return TokenElementIndex.open(projectStorageSystem, historyAccessOption);
    }

    public static MetricDirectoryEntry createEmptyMetricDirectoryEntry(UniformPath uniformPath) {
        MetricDirectorySchema emptySchema = MetricDirectorySchema.EMPTY;
        MetricDirectoryEntry entry = new MetricDirectoryEntry(uniformPath.toString(), emptySchema);
        entry.insertOrUpdateChild(new MetricDirectoryEntry("empty", emptySchema));
        return entry;
    }

    public static void adjustSchemaEntries(MetricDirectorySchema schema, MetricDirectoryEntry entry) {
        Object[] values = entry.getValues();
        CCSMAssert.isTrue((values.length <= schema.getAllEntries().size() ? 1 : 0) != 0, () -> String.format("Received more entries \"%s\" than expected by the schema %s", Arrays.toString(values), schema));
        if (values.length < schema.getAllEntries().size()) {
            Object[] newValues = ResourceServiceUtils.calculateDeltaToSchema(schema, values);
            ResourceServiceUtils.updateEntry(newValues, entry);
        }
    }

    private static Object[] calculateDeltaToSchema(MetricDirectorySchema schema, Object[] values) {
        Object[] newValues = new Object[schema.getAllEntries().size() - values.length];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = schema.getEntry(values.length + i).getValueType().getDefaultValue();
        }
        return newValues;
    }

    private static void updateEntry(Object[] newAdditionalValues, MetricDirectoryEntry entry) {
        entry.setValues(CollectionUtils.concatenateArrays((Object[])entry.getValues(), (Object[])newAdditionalValues));
        for (Map.Entry childEntry : entry.getChildMetricsMap().entrySet()) {
            Object[] newValue = CollectionUtils.concatenateArrays((Object[])((Object[])childEntry.getValue()), (Object[])newAdditionalValues);
            entry.setChildMetrics((String)childEntry.getKey(), newValue);
        }
    }

    public static String getUniformPathPrefixContainerAware(ContainerIndex containerIndex, String uniformPathPrefix) throws StorageException {
        if (StringUtils.isEmpty((String)uniformPathPrefix)) {
            return "";
        }
        String uniformPathWithoutTrailingSlash = StringUtils.stripSuffix((String)uniformPathPrefix, (String)UniformPathUtils.SEPARATOR);
        EResourceType resourceType = containerIndex.getResourceType(uniformPathWithoutTrailingSlash);
        return switch (resourceType) {
            default -> throw new MatchException(null, null);
            case EResourceType.CONTAINER -> uniformPathWithoutTrailingSlash + UniformPathUtils.SEPARATOR;
            case EResourceType.FILE -> uniformPathWithoutTrailingSlash;
            case EResourceType.UNKNOWN -> uniformPathPrefix;
        };
    }

    private ResourceServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

