/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.SimulinkModelInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;

@Index(name="simulink-model-info", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={SimulinkModelInfo.class})
public class SimulinkModelInfoIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "simulink-model-info";
    private static final byte[] SEPARATOR = new byte[]{1};
    private static final byte[] MODEL_INFO_KEY_PREFIX = new byte[]{2};
    private static final byte[] MODEL_NAME_KEY_PREFIX = new byte[]{3};
    private static final byte[] BLOCK_ID_KEY_PREFIX = new byte[]{4};
    private static final byte[] SIMPLE_FILE_NAME_KEY_PREFIX = new byte[]{5};
    private static final Logger LOGGER = LogManager.getLogger();

    public SimulinkModelInfoIndex(IStore store) {
        super(store);
    }

    public void addOrUpdateModel(String uniformPath, SimulinkModel model) throws StorageException {
        this.removeByUniformPaths(Collections.singletonList(uniformPath));
        if (model == null) {
            return;
        }
        SimulinkModelInfo info = new SimulinkModelInfo(model);
        PairList data = new PairList();
        data.add((Object)SimulinkModelInfoIndex.makeModelInfoKey(uniformPath), (Object)StorageUtils.serialize((Serializable)info));
        data.add((Object)SimulinkModelInfoIndex.makeModelNameKey(uniformPath, info.getModelName()), (Object)SEPARATOR);
        data.add((Object)this.makeModelSimpleFileNameKey(uniformPath), (Object)SEPARATOR);
        for (String id : info.getBlockIds()) {
            data.add((Object)SimulinkModelInfoIndex.makeBlockIdKey(uniformPath, id), (Object)SEPARATOR);
        }
        this.store.put(data);
    }

    public void removeByUniformPaths(List<String> uniformPaths) throws StorageException {
        ArrayList<byte[]> pathsToDelete = new ArrayList<byte[]>();
        for (String uniformPath : uniformPaths) {
            SimulinkModelInfo modelInfo = this.loadModelInfo(uniformPath);
            if (modelInfo == null) continue;
            pathsToDelete.add(SimulinkModelInfoIndex.makeModelInfoKey(uniformPath));
            pathsToDelete.add(SimulinkModelInfoIndex.makeModelNameKey(uniformPath, modelInfo.getModelName()));
            pathsToDelete.add(this.makeModelSimpleFileNameKey(uniformPath));
            pathsToDelete.addAll(CollectionUtils.map(modelInfo.getBlockIds(), id -> SimulinkModelInfoIndex.makeBlockIdKey(uniformPath, id)));
        }
        if (!pathsToDelete.isEmpty()) {
            this.store.remove(pathsToDelete);
        }
    }

    private SimulinkModelInfo loadModelInfo(String uniformPath) throws StorageException {
        return (SimulinkModelInfo)StorageUtils.deserialize((byte[])this.store.get(SimulinkModelInfoIndex.makeModelInfoKey(uniformPath)));
    }

    private static byte[] makeModelInfoKey(String uniformPath) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{MODEL_INFO_KEY_PREFIX, StringUtils.stringToBytes((String)uniformPath)});
    }

    private static byte[] makeModelNameKey(String uniformPath, String modelName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{MODEL_NAME_KEY_PREFIX, StringUtils.stringToBytes((String)modelName), SEPARATOR, StringUtils.stringToBytes((String)uniformPath)});
    }

    private static byte[] makeBlockIdKey(String uniformPath, String blockId) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{BLOCK_ID_KEY_PREFIX, StringUtils.stringToBytes((String)SimulinkBlock.replaceNewlines((String)blockId)), SEPARATOR, StringUtils.stringToBytes((String)uniformPath)});
    }

    private byte[] makeModelSimpleFileNameKey(String uniformPath) {
        String filenameWithoutExtension = FileSystemUtils.getFilenameWithoutExtension((String)UniformPathUtils.getElementName((String)uniformPath));
        return ByteArrayUtils.concat((byte[][])new byte[][]{SIMPLE_FILE_NAME_KEY_PREFIX, StringUtils.stringToBytes((String)filenameWithoutExtension), SEPARATOR, StringUtils.stringToBytes((String)uniformPath)});
    }

    public List<String> getUniformPathsForModelName(String modelName) throws StorageException {
        for (String alternativeModelName : SimulinkModelInfoIndex.createAlternativeModelNames(modelName)) {
            List<String> uniformPaths = this.scanUniformPathKeys(ByteArrayUtils.concat((byte[][])new byte[][]{MODEL_NAME_KEY_PREFIX, StringUtils.stringToBytes((String)alternativeModelName), SEPARATOR}));
            if (uniformPaths.isEmpty()) continue;
            return uniformPaths;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getModelNamesToPathMap() throws StorageException {
        HashMap<String, String> keys = new HashMap<String, String>();
        this.store.scanKeys(MODEL_NAME_KEY_PREFIX, (key, value) -> {
            Map map = keys;
            synchronized (map) {
                byte[] keyWithoutPrefix = Arrays.copyOfRange(key, MODEL_NAME_KEY_PREFIX.length, key.length);
                List modelNameAndPath = ByteArrayUtils.split((byte[])keyWithoutPrefix, (byte[])SEPARATOR);
                byte[] modelName = (byte[])modelNameAndPath.get(0);
                byte[] modelPath = (byte[])modelNameAndPath.get(1);
                keys.put(StringUtils.bytesToString((byte[])modelName), StringUtils.bytesToString((byte[])modelPath));
            }
        });
        return keys;
    }

    public Optional<String> getUniqueUniformPathForModelName(String modelName) throws StorageException {
        List<String> uniformPaths = this.getUniformPathsForModelName(modelName);
        if (uniformPaths.isEmpty()) {
            LOGGER.warn("No model uniform path found for model name " + modelName);
            return Optional.empty();
        }
        if (uniformPaths.size() > 1) {
            LOGGER.warn("Multiple model uniform paths found for model name " + modelName + ": " + String.valueOf(uniformPaths));
            return Optional.empty();
        }
        return Optional.of(uniformPaths.get(0));
    }

    public List<String> getUniformPathsForBlockId(String blockId) throws StorageException {
        String escapedBlockId = SimulinkBlock.replaceNewlines((String)blockId);
        return this.scanUniformPathKeys(ByteArrayUtils.concat((byte[][])new byte[][]{BLOCK_ID_KEY_PREFIX, StringUtils.stringToBytes((String)escapedBlockId), SEPARATOR}));
    }

    public List<String> getUniformPathsWithSimpleFileName(String simpleFileName) throws StorageException {
        return this.scanUniformPathKeys(ByteArrayUtils.concat((byte[][])new byte[][]{SIMPLE_FILE_NAME_KEY_PREFIX, StringUtils.stringToBytes((String)simpleFileName), SEPARATOR}));
    }

    private List<String> scanUniformPathKeys(byte[] prefix) throws StorageException {
        List<String> result = Collections.synchronizedList(new ArrayList());
        this.store.scanKeys(prefix, (key, value) -> result.add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, prefix.length, key.length))));
        return result;
    }

    public List<SimulinkModelInfo> getModelInfos(List<String> uniformPaths) throws StorageException {
        List keys = CollectionUtils.map(uniformPaths, SimulinkModelInfoIndex::makeModelInfoKey);
        List values = this.store.get(keys);
        return CollectionUtils.mapWithException((Collection)values, StorageUtils::deserialize);
    }

    public static List<String> createAlternativeModelNames(String baseName) {
        baseName = StringUtils.stripPrefixIgnoreCase((String)baseName, (String)"Lib_");
        return Arrays.asList(baseName, "LIB_" + baseName, "Lib_" + baseName);
    }

    public Optional<ElementLocation> resolve(QualifiedNameLocation simulinkModelLocation) throws StorageException {
        Object[] qualifiedNameParts = simulinkModelLocation.getQualifiedName().split(UniformPathUtils.SEPARATOR);
        String fullModelName = qualifiedNameParts[0];
        String strippedModelName = StringUtils.stripPrefixIgnoreCase((String)fullModelName, (String)"Lib_");
        for (int i = 0; i <= qualifiedNameParts.length; ++i) {
            for (String modelName : Arrays.asList(fullModelName + UniformPathUtils.SEPARATOR + strippedModelName, fullModelName)) {
                String targetBlockId = SimulinkModelInfoIndex.makePath(modelName, (String[])ArrayUtils.subarray((Object[])qualifiedNameParts, (int)1, (int)(qualifiedNameParts.length - i)));
                List<String> foundUniformPaths = this.getUniformPathsForBlockId(targetBlockId);
                if (foundUniformPaths.isEmpty()) continue;
                if (foundUniformPaths.size() > 1) {
                    LOGGER.error("Ambiguous Simulink model name: " + targetBlockId + ". External uploads and sibling findings intended for this model will not be resolved.");
                }
                String uniformPath = foundUniformPaths.get(0);
                boolean abbreviated = i != 0;
                return Optional.of(new QualifiedNameLocation(targetBlockId, uniformPath, abbreviated));
            }
        }
        return Optional.empty();
    }

    public static String makePath(String modelName, String[] pathElements) {
        Object result = modelName;
        String path = StringUtils.concat((Object[])pathElements, (String)UniformPathUtils.SEPARATOR);
        if (!StringUtils.isEmpty((String)path)) {
            result = (String)result + UniformPathUtils.SEPARATOR + path;
        }
        return result;
    }
}

