/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.metrics.directory.HiddenMetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexBase;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.IMetricSchemaRetriever;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyBase;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public abstract class IndexMetricRetrievalStrategyBase
extends MetricRetrievalStrategyBase
implements IMetricRetrievalStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final boolean onlyHidden;

    protected IndexMetricRetrievalStrategyBase(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, IMetricSchemaRetriever schemaRetriever, boolean onlyHidden) {
        super(projectStorageSystem, globalStorageSystem, currentUser, schemaRetriever);
        this.onlyHidden = onlyHidden;
    }

    protected MetricDirectoryIndexBase openMetricDirectoryIndex(HistoryAccessOption historyAccessOption) throws StorageException {
        if (this.onlyHidden) {
            return (MetricDirectoryIndexBase)this.projectStorageSystem.openProjectIndex(HiddenMetricDirectoryIndex.class, historyAccessOption);
        }
        return (MetricDirectoryIndexBase)this.projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyAccessOption);
    }

    @Override
    public final MetricDirectorySchemaEntry getMetricDirectorySchemaEntry(String metricName) throws StorageException {
        return IndexMetricRetrievalStrategyBase.getMetricDirectorySchemaEntry(this.getMetricDirectorySchema(), metricName);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectorySchema schema = this.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption());
        return IndexMetricRetrievalStrategyBase.getDirectMetricDirectoryEntry(this.openMetricDirectoryIndex(historyAccessOption), schema, IndexMetricRetrievalStrategyBase.stripPath(uniformPath), historyAccessOption);
    }

    @Override
    public boolean hasMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return IndexMetricRetrievalStrategyBase.hasDirectMetricDirectoryEntry(this.openMetricDirectoryIndex(historyAccessOption), IndexMetricRetrievalStrategyBase.stripPath(uniformPath), historyAccessOption);
    }

    protected List<TrendIndexBase.TrendEntry<Object[]>> extractTrend(MetricTrendIndex trendIndex, UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        List<ParentedCommitDescriptor> relevantCommits = this.getTrendRelevantCommits(start, end);
        return trendIndex.extractTrend(uniformPath.toString(), relevantCommits);
    }

    protected List<ParentedCommitDescriptor> getTrendRelevantCommits(CommitDescriptor start, CommitDescriptor end) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)this.projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        CommitDescriptor realEnd = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(end, start.getTimestamp()).orElse(end);
        return commitDescriptorIndex.getCommitHistoryWithFirstParentCommits(realEnd, start.getTimestamp());
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        IndexMetricRetrievalStrategyBase.ensureNotNullOrEmpty(uniformPathPrefixes);
        MetricDirectoryIndexBase metricDirectoryIndex = this.openMetricDirectoryIndex(historyAccessOption);
        return metricDirectoryIndex.getMetricDirectoryEntriesForUniformPathPrefixes(uniformPathPrefixes);
    }

    protected void verifyNotHiddenForTrend() {
        if (this.onlyHidden) {
            throw new UnsupportedOperationException("Trend is only available for non-hidden metrics");
        }
    }

    protected static MetricDirectorySchemaEntry getMetricDirectorySchemaEntry(MetricDirectorySchema metricSchema, String metricName) {
        int valuePosition = metricSchema.getValuePosition(metricName);
        if (valuePosition == -1) {
            return null;
        }
        return metricSchema.getEntry(valuePosition);
    }

    private static MetricDirectoryEntry getDirectMetricDirectoryEntry(MetricDirectoryIndexBase index, MetricDirectorySchema schema, String uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        if (historyAccessOption == null) {
            return null;
        }
        MetricDirectoryEntry entry = index.getMetricDirectoryEntry(uniformPath);
        if (entry == null) {
            if (!StringUtils.isEmpty((String)uniformPath)) {
                LOGGER.warn("No entry metric directory entry found for: " + uniformPath);
            }
            return entry;
        }
        ResourceServiceUtils.adjustSchemaEntries(schema, entry);
        return entry;
    }

    private static boolean hasDirectMetricDirectoryEntry(MetricDirectoryIndexBase index, String uniformPath, @Nullable HistoryAccessOption historyAccessOption) throws StorageException {
        if (historyAccessOption == null) {
            return false;
        }
        return index.getMetricDirectoryEntry(uniformPath) != null;
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema(HistoryAccessOption historyAccess) throws StorageException {
        HistoryAccessOption unbranched = historyAccess.cloneToUnbranchedAccessOption();
        if (this.onlyHidden) {
            return this.schemaRetriever.getHiddenMetricSchema(unbranched);
        }
        return this.schemaRetriever.getPublicMetricSchema(unbranched);
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema() throws StorageException {
        if (this.onlyHidden) {
            return this.schemaRetriever.getHiddenMetricSchema();
        }
        return this.schemaRetriever.getPublicMetricSchema();
    }
}

