/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.resource.ResourceServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableListIterator;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class MetricRetrievalStrategyUtils {
    public static List<IMetricSource> getMetricSources(MetricDirectorySchema schema) {
        ArrayList<IMetricSource> metricSources = new ArrayList<IMetricSource>(schema.getAllEntries().size());
        UnmodifiableListIterator iter = schema.getAllEntries().listIterator();
        while (iter.hasNext()) {
            MetricDirectorySchemaEntry entry = (MetricDirectorySchemaEntry)iter.next();
            IndexMetricSource metricSource = new IndexMetricSource(entry.getName());
            metricSource.init(iter.previousIndex(), schema);
            metricSources.add((IMetricSource)metricSource);
        }
        return metricSources;
    }

    public static Object[] concatArrays(Object[] a1, Object[] a2) {
        Object[] target = new Object[a1.length + a2.length];
        System.arraycopy(a1, 0, target, 0, a1.length);
        System.arraycopy(a2, 0, target, a1.length, a2.length);
        return target;
    }

    public static MetricDirectoryEntry aggregateEntries(String uniformPath, Collection<MetricDirectoryEntry> entries, MetricDirectorySchema schema) {
        if (entries.isEmpty()) {
            MetricDirectoryEntry dummyEntry = new MetricDirectoryEntry(uniformPath, 0);
            ResourceServiceUtils.adjustSchemaEntries(schema, dummyEntry);
            return dummyEntry;
        }
        if (entries.size() == 1) {
            MetricDirectoryEntry entry = entries.iterator().next();
            return MetricRetrievalStrategyUtils.copyWithUniformPath(uniformPath, entry);
        }
        List<Object[]> itemsMetrics = entries.stream().map(MetricDirectoryEntry::getValues).toList();
        MetricDirectoryEntry result = new MetricDirectoryEntry(uniformPath, MetricRetrievalStrategyUtils.aggregateMetrics(itemsMetrics, schema));
        Map childMetrics = entries.stream().map(MetricDirectoryEntry::getChildMetricsMap).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (Map.Entry entry : childMetrics.entrySet()) {
            result.setChildMetrics(entry.getKey(), MetricRetrievalStrategyUtils.aggregateMetrics(entry.getValue(), schema));
        }
        return result;
    }

    private static MetricDirectoryEntry copyWithUniformPath(String uniformPath, MetricDirectoryEntry entry) {
        if (Objects.equals(uniformPath, entry.getUniformPath())) {
            return entry;
        }
        MetricDirectoryEntry result = new MetricDirectoryEntry(uniformPath, entry.getValues());
        entry.getChildMetricsMap().forEach((arg_0, arg_1) -> ((MetricDirectoryEntry)result).setChildMetrics(arg_0, arg_1));
        return result;
    }

    public static Object[] aggregateMetrics(List<Object[]> metrics, MetricDirectorySchema schema) {
        if (metrics.isEmpty()) {
            MetricDirectoryEntry dummyEntry = new MetricDirectoryEntry("dummy", 0);
            ResourceServiceUtils.adjustSchemaEntries(schema, dummyEntry);
            return dummyEntry.getValues();
        }
        if (metrics.size() == 1) {
            return metrics.get(0);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        List<IMetricSource> metricSources = MetricRetrievalStrategyUtils.getMetricSources(schema);
        ListIterator<IMetricSource> iter = metricSources.listIterator();
        while (iter.hasNext()) {
            IMetricSource metricSource = iter.next();
            int index = iter.previousIndex();
            MetricDirectorySchemaEntry metric = schema.getEntry(index);
            List<Object> values = metrics.stream().map(itemMetrics -> itemMetrics[index]).toList();
            result.add(metricSource.aggregate(values, metric));
        }
        return result.toArray(Object[]::new);
    }

    private MetricRetrievalStrategyUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

