/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.webhook;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.tracking.FindingChurnCount;
import com.teamscale.index.tracking.index.FindingChurnCountIndex;
import com.teamscale.index.webhook.CommitAnalyzedWebhookPayload;
import com.teamscale.index.webhook.WebhookPayload;
import com.teamscale.index.webhook.WebhookSender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CommitAnalyzedWebhookTrigger
extends PostRevisionAnalysisTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException, ExecutionCanceledException {
        if (ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.openGlobalStorageSystem())) {
            LOGGER.atInfo().withMarker(LoggingUtils.INTERACTION).log("Skipping post-commit webhook because shadow mode is enabled.");
            return;
        }
        CommitDescriptor commit = this.jobDescriptor.getSchedulingCommit();
        if (commit == null) {
            LOGGER.debug("No commit available for webhook trigger. Skipping.");
            return;
        }
        try {
            this.sendWebhook(commit);
        }
        catch (ServiceCallException e) {
            LOGGER.error("Failed to send post-commit webhook.", (Throwable)e);
        }
    }

    private void sendWebhook(CommitDescriptor commit) throws StorageException, ServiceCallException {
        PublicProjectId projectId = this.getPrimaryPublicId();
        FindingChurnCount findingChurnCount = this.getFindingChurnCount(commit);
        CommitAnalyzedWebhookPayload postCommitPayload = CommitAnalyzedWebhookPayload.from(projectId, commit, this.getRevision(commit), findingChurnCount);
        WebhookPayload<CommitAnalyzedWebhookPayload> payload = WebhookPayload.forCommitAnalyzed(postCommitPayload);
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class);
        WebhookSender.sendWebhook(serverOptionIndex, payload);
        LOGGER.atInfo().withMarker(LoggingUtils.INTERACTION).log("Successfully sent post-commit webhook for commit {} in project {}.", (Object)commit, (Object)projectId);
    }

    private @NonNull FindingChurnCount getFindingChurnCount(CommitDescriptor commit) throws StorageException {
        FindingChurnCountIndex findingChurnCountIndex = (FindingChurnCountIndex)this.openIndexInProject(FindingChurnCountIndex.class);
        FindingChurnCount findingChurnCount = (FindingChurnCount)findingChurnCountIndex.getEntry(commit);
        if (findingChurnCount == null) {
            findingChurnCount = new FindingChurnCount(commit, 0, 0, 0, 0, 0);
        }
        return findingChurnCount;
    }

    private @Nullable String getRevision(CommitDescriptor commit) {
        try {
            RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)this.openIndexInProject(RepositoryLogIndex.class);
            RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(commit);
            if (logEntry != null) {
                return logEntry.getRevision();
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Failed to retrieve revision for commit {}. Sending webhook without revision.", (Object)commit, (Object)e);
        }
        return null;
    }
}

