Missing or misused access rule annotations can lead to unauthorized access to ABAP CDS entities.
# What Does This Check Look For?

This check searches for `@AccessControl.authorizationCheck` annotations before an abap cds view definition and checks
depending on the given parameter if the defined view gets used in at least one access control object.
Also checks if access control objects use a certain view but the view does not declare this in its annotation.



If `@AccessControl.authorizationCheck` is set to `#CHECK`, the view must be used in at least one access control object.
Otherwise, the view is not allowed to get used in any access control object.

This check gets suppressed by every parameter of `@AccessControl.authorizationCheck` which gets declared in the `Access control authorization - suppress finding for`
check option and does not show a finding. One way or the other.

# Why is This a Problem?

A violation may lead to unauthorized access to _ABAP CDS_ entities.
