Do not use the `continue` or `break` keyword in combination with a label.

# Why is This a Problem?
The usage of `continue` or `break` in combination with a label is discouraged as it is bad practice and leads to code that is hard to read.
Usage of  a labelled `continue` or `break` is often an indication of bad design.

# How Can I Resolve This?
The solutions to this issue are manifold and depend on the specific context in which the label is used.
However, most of the time simple refactoring techniques can remedy the issue. 
The following questions may be helpful:
- Is the nested construct really necessary? Is there a simpler way to solve this?
- Can the nested construct be outsourced to a function of its own and the labelled `break` / `continue` replaced by a return statement?

## Example (Before)

```java
int[][] arr = new int[10][20];
...
bool containsZero = false;
loop:
for (int i = 0; i < arr.length) {
  for (int j = 0; j < arr[0].length) {
    if (arr[i][j] == 0) {
      containsZero = true;
      break loop;
    }
  }	
}
...
```

## Example (After)

```java
bool containsZeros(int[][] a) {
  for (int i = 0; i < arr.length) {
    for (int j = 0; j < arr[0].length) {
      if (arr[i][j] == 0) {
        return true;
      }
    }
  }
}

...
        
int[][] arr = new int[10][20];
...
bool containsZero = containsZeros(arr);
```