Using line splicing in comments can make code difficult to read and increases the risk of accidentally breaking it when comments are modified.
To resolve this, remove the backslash `\` at the end of the comment and ensure that comments are properly formatted without any line splicing.

# What Does This Check Look For?

This check searches for comments in the source code that use line splicing.

# Why is This a Problem?

Using line splicing in comments can accidentally lead to broken code when a comment is modified.

```c
// This comment used to span two lines before the second line was deleted \
printf("causing this statement to become a part of the comment.");
printf("This statement is (still) not part of the comment.");
```

Besides the risk of accidentally breaking code, line splicing also hampers readability.
In particular, when using an editor without syntax highlighting, it becomes harder to see which lines actually constitute a comment.

As line splicing in comments is also unnecessary, it is best to avoid it altogether.
You can always use a single block or multiple line comments instead.

# How Can I Resolve This?

Remove the backslash `\` at the end of the comment and use a block comment or multiple line comments instead.

# Examples

## Non-Compliant

```c
// This is a comment \
   spanning multiple lines.
```

## Compliant

```c
// This is a comment
// spanning multiple lines.
```

or

```c
/* This is a comment
   spanning multiple lines */
```

