Passive voice can create ambiguity and confusion.
Always aim to use active voice for more precise and clear instructions.

# What Does This Check Look For?

This check scans the fields of items looking for instances of passive voice.
It reports a finding whenever it encounters a sentence or phrase where the subject is acted upon by the verb, rather than performing the action.

# Why is This a Problem?

The use of passive voice can lead to unclear or ambiguous specifications.
This could cause confusion, misinterpretation, or potential errors in the implementation.
Hence, promoting active voice will typically lead to more concise and precise item descriptions.

# How Can I Resolve This?

You can resolve this by revising the detected instances of passive voice and transforming them into active voice.
This generally involves a change in sentence structure,
making sure that the subject of your sentence is actively undertaking an action rather than being acted upon.

# Examples

## Non-Compliant

```markdown
"The product functionality is to be defined by the specification."

// non-compliant: Passive voice used.
```

## Compliant

```markdown
"The specification defines the product functionality."

// compliant: Active voice used.
```

# Where Can I Learn More?

- [Guide: Plain Language Guidelines: Use the Active Voice](https://www.plainlanguage.gov/guidelines/conversational/use-active-voice/)
- [Grammarly: Active Voice Vs. Passive Voice: Finally Understand The Difference](https://www.grammarly.com/blog/active-vs-passive-voice/)