<h2>Why is this an issue?</h2>
<p>When a test fails due, for example, to infrastructure issues, you might want to ignore it temporarily. But without some kind of notation about why
the test is being ignored, it may never be reactivated. Such tests are difficult to address without comprehensive knowledge of the project, and end up
polluting their projects.</p>
<p>This rule raises an issue for each ignored test that does not have any comment about why it is being skipped.</p>
<ul>
  <li> For Junit4, this rule targets the @Ignore annotation. </li>
  <li> For Junit5, this rule targets the @Disabled annotation. </li>
  <li> Cases where assumeTrue(false) or assumeFalse(true) are used to skip tests are targeted as well. </li>
</ul>
<h3>Noncompliant code example</h3>

```java
@Ignore  // Noncompliant
@Test
public void testDoTheThing() {
  // ...
```
<p>or</p>

```java
@Test
public void testDoTheThing() {
  Assume.assumeFalse(true); // Noncompliant
  // ...
```
<h3>Compliant solution</h3>

```java
@Test
@Ignore("See Ticket #1234")
public void testDoTheThing() {
  // ...
```