<h2>Why is this an issue?</h2>
<p>Assertions are intended to be used in <strong>test</strong> code, but not in <strong>production</strong> code. It is confusing, and might lead to
<code>ClassNotFoundException</code> when the build tools only provide the required dependency in test scope.</p>
<p>In addition, assertions will throw a sub-class of <code>Error</code>: <code>AssertionError</code>, which should be avoided in production code.</p>
<p>This rule raises an issue when any assertion intended to be used in test is used in production code.</p>
<p>Supported frameworks:</p>
<ul>
  <li> JUnit </li>
  <li> FestAssert </li>
  <li> AssertJ </li>
</ul>
<p>Note: this does not apply for <code>assert</code> from Java itself or if the source code package name is related to tests (contains:
<code>test</code> or <code>assert</code> or <code>junit</code>).</p>