# Description
Add test attributes `DURATION` and `RISK LEVEL` for tests classes with test methods

# Examples
**Bad example**
```abap
CLASS ltcl_test1 DEFINITION FINAL FOR TESTING.
  PUBLIC SECTION.
  PROTECTED SECTION.
  PRIVATE SECTION.
    METHODS test FOR TESTING RAISING cx_static_check.
ENDCLASS.

CLASS ltcl_test1 IMPLEMENTATION.
  METHOD test.
  ENDMETHOD.
ENDCLASS.
```

**Good example**
```abap
CLASS ltcl_test2 DEFINITION FINAL FOR TESTING DURATION SHORT RISK LEVEL HARMLESS.
  PUBLIC SECTION.
  PROTECTED SECTION.
  PRIVATE SECTION.
    METHODS test FOR TESTING RAISING cx_static_check.
ENDCLASS.

CLASS ltcl_test2 IMPLEMENTATION.
  METHOD test.
  ENDMETHOD.
ENDCLASS.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/add_test_attributes) <br>
