# Rule 19.1 An object shall not be assigned or copied to an overlapping object

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99

## Rationale
The behaviour is undefined when two objects are created which have some overlap in memory and
one is assigned or copied to the other.

## Exception
The following are permitted because the behaviour is well-defined:
1. Assignment between two objects that overlap exactly and have compatible types (ignoring
their type qualifiers)
2. Copying between objects that overlap partially or completely using The Standard Library
function `memmove`

## Example
This example also violates Rule 19.2 because it uses unions.
```c
void fn ( void )
{
 union
 {
 int16_t i;
 int32_t j;
 } a = { 0 }, b = { 1 };
 
 a.j = a.i; /* Non-compliant */
 a = b; /* Compliant - exception 1 */
}
#include <string.h>
int16_t a[ 20 ];
void f ( void )
{
 memcpy ( &a[ 5 ], &a[ 4 ], 2u * sizeof ( a[ 0 ] ) ); /* Non-compliant */
}
void g ( void )
{
 int16_t *p = &a[ 0 ];
 int16_t *q = &a[ 0 ];
 *p = *q; /* Compliant - exception 1 */
}
```

## See also
Rule 19.2

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
