# Rule 22.1 All resources obtained dynamically by means of Standard Library functions shall be explicitly released

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99

## Amplification
The Standard Library functions that allocate resources are *malloc*, *calloc*, *realloc* and *fopen*.

## Rationale
If resources are not explicitly released then it is possible for a failure to occur due to exhaustion of
those resources. Releasing resources as soon as possible reduces the possibility that exhaustion will
occur.

## Example
```c
#include <stdlib.h>
int main ( void )
{
 void *b = malloc ( 40 );
 /* Non-compliant - dynamic memory not released */
 return 1;
}
#include <stdio.h>
int main ( void )
{
 FILE *fp = fopen ( "tmp", "r" );
 /* Non-compliant - file not closed */
 return 1;
}
```
In the following non-compliant example, the handle on "tmp-1" is lost when "tmp-2" is opened.
```c
#include <stdio.h>
int main ( void )
{
 FILE *fp;
 fp = fopen ( "tmp-1", "w" );
 fprintf ( fp, "*" );
 /* File "tmp-1" should be closed here, but stream 'leaks'. */
 fp = fopen ( "tmp-2", "w" );
 fprintf ( fp, "!" );
 fclose ( fp );
 return ( 0 );
}
```

## See also
Dir 4.12, Dir 4.13, Rule 21.3, Rule 21.6

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
