# Rule 17.5 The function argument corresponding to a parameter declared to have an array type shall have an appropriate number of elements

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
If a parameter is declared as an array with a specified size, the corresponding argument in each function call shall point into an object that has at least as many elements as the array.

## Rationale
The use of an array declarator for a function parameter specifies the function interface more clearly than using a pointer. The minimum number of elements expected by the function is explicitly stated, whereas this is not possible with a pointer.

A function parameter array declarator which does not specify a size is assumed to indicate that the function can handle an array of any size. In such cases, it is expected that the array size will be communicated by some other means, for example by being passed as another parameter, or by terminating the array with a sentinel value.

The use of an array bound is recommended as it allows out-of-bounds checking to be implemented within the function body and extra checks on parameter passing. It is legal in C to pass an array of the incorrect size to a parameter with a specified size, which can lead to unexpected behaviour.

## Example
```c
/*
 * Intent is that function does not access outside the range
 * array1[ 0 ] .. array1[ 3 ] 
 */
void fn1 ( int32_t array1[ 4 ] );

/* Intent is that function handles arrays of any size */
void fn2 ( int32_t array2[ ] );

void fn ( int32_t *ptr )
{
  int32_t arr3[ 3 ] = { 1, 2, 3 };
  int32_t arr4[ 4 ] = { 0, 1, 2, 3 };

  /* Compliant - size of array matches the prototype */
  fn1 ( arr4 );

  /* Non-compliant - size of array does not match prototype */
  fn1 ( arr3 );

  /* Compliant only if ptr points to at least 4 elements */
  fn1 ( ptr );

  /* Compliant */
  fn2 ( arr4 );

  /* Compliant */
  fn2 ( ptr );
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].