# Rule 22.15 Thread synchronization objects and thread-specific storage pointers shall not be destroyed until after all threads accessing them have terminated

## Category
Required

## Analysis
Undecidable, System

## Applies to
C11

## Rationale
The Standard Library function *mtx_destroy(mtx)* releases all resources used by the mutex pointed to by *mtx*. Destroying a mutex which is still locked by some thread results in undefined behaviour, as the C Standard expects no threads to be blocked by a mutex when it is destroyed.

The Standard Library function *tss_delete(key)* releases all resources used by the thread-specific storage identified by *key*. Calling the *tss_delete()*, *tss_get()* or *tss_set()* functions after the thread commenced executing destructors results in undefined behaviour.

Calling the Standard Library function *cnd_destroy()*, on a condition variable on which a thread is currently waiting, results in undefined behaviour.

These problems are avoided by only destroying synchronization resources and deleting thread-specific storage after all threads accessing them have terminated (or not at all).

## Example
```c
mtx_t Ra;
mtx_t Rb;
tss_t key1;
tss_t key2;
thrd_t id1;
thrd_t id2;

int32_t t1( void *ignore ) /* Thread T1 entry */
{
  /*
  ** locks/unlocks Ra, Rb
  ** accesses thread-specific storage pointed to by key1, key2
  */
  
  tss_delete( key1 ); /* Non-compliant - might still be accessed from T2 */
}

int32_t t2( void *ignore ) /* Thread T2 entry */
{
  /*
  ** locks/unlocks Ra, Rb
  ** accesses thread-specific storage pointed to by key1, key2
  */
  mtx_destroy( &Rb ); /* Non-compliant - T1 might still access Rb */
}

void main( void )
{
  mtx_init ( &Ra, mtx_plain );
  mtx_init ( &Rb, mtx_plain );
  
  tss_create ( &key1, NULL );
  tss_create ( &key2, NULL ); 
  
  thrd_create( &id1, t1, NULL );
  thrd_create( &id2, t2, NULL );
  
  spendSomeTime();

  tss_delete ( key2 ); /* Non-compliant - might still be accessed by t1, t2 */

  thrd_join ( id1, NULL );
  thrd_join ( id2, NULL );
  
  mtx_destroy( &Ra );  /* Compliant */
  tss_delete ( key1 ); /* Compliant */
}
```

## See also
Rule 22.1

---

Copyright The MISRA Consortium Limited © [Date - March 2025].