# Rule 22.3 The same file shall not be open for read and write access at the same time on different streams

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
This rule applies to files opened with the Standard Library functions. It may also apply to similar features provided by the execution environment.

## Rationale
The C Standard does not specify the behaviour if a file is both written and read via different streams.

*Note:* it is acceptable to open a file multiple times for read-only access.

## Example
```c
#include <stdio.h>

void fn ( void )
{
  FILE *fw = fopen ( "tmp", "r+" ); /* "r+" opens for read/write */
  FILE *fr = fopen ( "tmp", "r" );  /* Non-compliant */
}
```

## See also
Rule 21.6

---

Copyright The MISRA Consortium Limited © [Date - March 2025].