# Rule 15–3–1 (Required) Exceptions shall be raised only after start-up and before termination of the program.

## Amplification
[Implementation 15.3(9), 15.5.1(2)]

## Rationale
Throwing an exception during start-up or termination results in the program being terminated in an implementation-defined manner.
Before the program starts executing the body of main, it is in a start-up phase, constructing and initializing static objects. Similarly, after main has returned, it is in a termination phase where static objects are being destroyed. If an exception is thrown in either of these phases it leads to the program being terminated in an implementation-defined manner. Specifically from Section 15.3(13) of ISO/IEC 14882:2003 [1], if main is implemented as a function-try-block, exceptions raised during start-up and close down are not caught by the catch block(s) of main.
This is in effect a special case of Rule 15–3–4, as there is nowhere a handler can be placed to catch exceptions thrown during start-up or termination.

## Example
```c
class C 
{ 
public: 
 C ( ) 
 { 
 throw ( 0 ); // Non-compliant – thrown before main starts 
 } 
 ~C ( ) 
 { 
 throw ( 0 ); // Non-compliant – thrown after main exits 
 } 
};
C c; // An exception thrown in C's constructor or destructor will 
 // cause the program to terminate, and will not be caught by 
 // the handler in main
int main( ... ) 
{ 
 try 
 { 
 // program code 
 return 0; 
 }
 // The following catch-all exception handler can only 
 // catch exceptions thrown in the above program code 
 catch ( ... ) 
 { 
 // Handle exception 
 return 0; 
 } 
}
```

## See also
Rule 15–3–3, Rule 15–3–4, Rule 15–5–1, Rule 15–5–3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
