# Rule 17–0–3 (Required) The names of standard library functions shall not be overridden.

## Category
Required

## Rationale
Where the developer uses new versions of standard library functions (e.g. to enhance functionality
or add checks of input values), the modified function shall have a new name. However, it is
permissible to overload the name to add new parameter types if the functionality is consistent
with those of the original. This ensures that the behaviour associated with the name remains
consistent. So, for example, if a new version of the sqrt function is written to check that the input
is not negative, the new function shall not be named “sqrt”, but shall be given a new name. It is
permissible to add a new sqrt function for a type not present in the library.

## Example
```cpp
int32_t printf ( int32_t a, int32_t b ) // Non-compliant 
{ 
 return ( ( a > b ) ? a : b ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
