# Rule 2–13–2 (Required) Octal constants (other than zero) and octal escape sequences (other than “\0”) shall not be used.

## Amplification
[Implementation 2.13.2(1, 2)]

## Rationale
Any integer constant beginning with a “0” (zero) is treated as octal. Because of this, it is possible for a zero-prefixed constant that is intended to be a decimal number to be incorrectly entered as an octal number, contrary to developer expectations.
Octal escape sequences can also be problematic because the inadvertent introduction of a decimal digit (i.e. “8” or “9”) ends the octal escape and introduces another character.
The integer constant zero (written as a single numeric digit), is strictly speaking an octal constant, but is a permitted exception to this rule. Additionally, “\0” is the only permitted octal escape sequence.

## Example
The following array initialization for 3-digit decimal bus messages would not behave as expected:
```c
code[ 1 ] = 109; // Compliant - decimal 109 
code[ 2 ] = 100; // Compliant - decimal 100 
code[ 3 ] = 052; // Non-compliant - equivalent to decimal 42 
code[ 4 ] = 071; // Non-compliant - equivalent to decimal 57
```
The value of the first expression in the following example is implementation‑defined because the character constant consists of two characters, “\10” and “9”. The second character constant expression contains the single character “\100”.
```c
code[ 5 ] = '\109'; // Non-compliant - implementation‑defined, 
 // two character constant 
code[ 6 ] = '\100'; // Non-compliant - set to 64.
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
