# Rule 3–3–2 (Required) If a function has internal linkage then all re-declarations shall include the static storage class specifier.

## Rationale
If the declaration of a function includes the static storage class specifier, then it has internal linkage.
A re-declaration of such a function is not required to have the static keyword, but it will still have internal linkage. However, this is implicit and may not be obvious to a developer. It is therefore good practice to apply the static keyword consistently so that the linkage is explicitly stated.

## Example
```c
static void f1 ( ); 
static void f2 ( );
 void f1 ( ) { } // Non-compliant 
static void f2 ( ) { } // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
