# Rule 3–9–1 (Required) The types used for an object, a function return type, or a function parameter shall be token-for-token identical in all declarations and re-declarations.

## Rationale
If a re-declaration has compatible types but not types which are token-for-token identical, it may not be clear to which declaration that re-declaration refers.

## Example
```c
typedef int32_t INT;
 INT i; 
extern int32_t i; // Non-compliant
 INT j; 
extern INT j; // Compliant
// The following lines break Rule 3–9–2 
extern void f ( signed int ); 
 void f ( int ); // Non-compliant 
extern void g ( const int ); 
 void g ( int ); // Non-compliant
```

## See also
Rule 3–2–1, Rule 3–9–2

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
