# Rule 5–0–8 (Required) An explicit integral or floating-point conversion shall not increase the size of the underlying type of a cvalue expression.

## Rationale
A cast applied to the result of an expression does not change the type in which the expression is evaluated, which may be contrary to developer expectations.

## Example
```c
void f ( ) 
{ 
 int16_t s16; 
 int32_t s32;
 s32 = static_cast< int32_t > ( s16 + s16 ); // Non-compliant 
 s32 = static_cast< int32_t > ( s16 ) + s16 ; // Compliant 
}
```
In the above example, the expression ( s16 + s16 ) is performed with an underlying type of int16_t rather than int32_t.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
