# Rule 5–2–9 (Advisory) A cast should not convert a pointer type to an integral type.

## Amplification
[Implementation 5.2.10(4, 5)]

## Rationale
The size of integer that is required when a pointer is converted to an integer is implementation-defined. Casting between a pointer and an integer type should be avoided where possible, but may be unavoidable when addressing memory mapped registers or other hardware specific features.
Note that C++ does not permit a pointer to be converted to any floating type.

## Example
```c
struct S 
{ 
 int32_t i; 
 int32_t j; 
};
void f ( S * s ) 
{ 
 int32_t p = reinterpret_cast< int32_t >( s ); // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
