# Rule 9–6–1 (Document) When the absolute positioning of bits representing a bit-field is required, then the behaviour and packing of bit-fields shall be documented.

## Amplification
[Implementation 9.6(1)]

## Rationale
Certain aspects of bit-fields are implementation-defined. In particular, the developer should be aware of the following:
* It is implementation-defined whether the bit-fields are allocated from the high or low end of a storage unit (usually a byte).
* It is implementation-defined whether or not a bit field can overlap a storage unit boundary (e.g. if a 6-bit bit-field and a 4-bit bit-field are declared in that order, then the 4-bit bit-field may either start a new byte or it may use 2 bits in one byte and 2 bits in the next).

These issues are generally benign (e.g. when packing together short-length data to save storage space), but they may lead to errors if the absolute position of the bit-fields is important (e.g. when accessing hardware registers).
Provided the elements of the structure are only accessed by name, the developer need make no assumptions about the way that the bit fields are stored within the structure.
Note that Rule 3–9–2 need not be followed when defining bit-fields, as their lengths are explicitly specified.
If the compiler has a switch to force bit fields to follow a particular layout, then this option should be documented.

## Example
```c
struct message // Struct is for bit-fields only 
{ 
 signed int little: 4; // Note: use of basic types is required 
 unsigned int x_set: 1; 
 unsigned int y_set: 1; 
} message_chunk;
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
