# Rule 5.7.1 The character sequence `/*` shall not be used within a C-style comment

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
C++ does not support the nesting of C-style comments, even though some compilers support this as
a non-portable language extension. A comment beginning with `/*` continues until the first `*/` is
encountered.

Any `/*` sequence occurring inside a C-style comment is a violation of this rule.

## Example
Consider the following code fragment:
```cpp
/* Some comment, end comment marker accidentally omitted

Perform_Critical_Safety_Function( X );
/* <- this is non-compliant */
```
In reviewing the code containing the call to the function, the assumption is that it is executed. However,
because the end comment marker is missing, the call to `Perform_Critical_Safety_Function`
will not be executed.

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
