# Rule 8.2.7 A cast should not convert a pointer type to an integral type

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Rationale
Casting between a pointer and an integer type makes it harder for tools and developers to understand
and reason about code behaviour. For example, pointer tracking within tools may become unreliable
when pointers are cast to integers.

Note: casting between pointers and integers may be unavoidable when addressing memory mapped
registers or other hardware specific features. When the advice given in this rule is not followed, the
use of `std::uintptr_t` or `std::intptr_t` is required by Rule 8.2.8 as these types are guaranteed
to be able to represent all possible pointer values.

## Example
The following examples violate Rule 8.2.5, with the second also violating Rule 8.2.8:
```cpp
struct S;

void f( S * s )
{
  std::intptr_t p = reinterpret_cast< std::intptr_t >( s ); // Non-compliant
  std::uint8_t q = reinterpret_cast< std::uint8_t >( s ); // Non-compliant
}
```

## See also
Rule 8.2.5, Rule 8.2.8

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
